/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import junit.framework.TestCase;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectNoop;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetAbstract;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;

public class FacetAbstractTest
extends TestCase {
    private FacetAbstract fooFacet;
    private FacetHolder facetHolder;
    private FacetHolder facetHolder2;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetHolder = new FacetHolderImpl();
        this.facetHolder2 = new FacetHolderImpl();
        this.fooFacet = new ConcreteFacet(FooFacet.class, this.facetHolder);
        new ConcreteFacet(BarFacet.class, this.facetHolder);
        this.facetHolder.addFacet((Facet)this.fooFacet);
    }

    protected void tearDown() throws Exception {
        this.fooFacet = null;
        this.facetHolder = null;
        super.tearDown();
    }

    public void testFacetType() {
        FacetAbstractTest.assertEquals(FooFacet.class, (Object)this.fooFacet.facetType());
    }

    public void testGetFacetHolder() {
        FacetAbstractTest.assertEquals((Object)this.facetHolder, (Object)this.fooFacet.getFacetHolder());
    }

    public void testSetFacetHolder() {
        this.fooFacet.setFacetHolder(this.facetHolder2);
        FacetAbstractTest.assertEquals((Object)this.facetHolder2, (Object)this.fooFacet.getFacetHolder());
    }

    public void testToString() {
        FacetAbstractTest.assertEquals((String)"FacetAbstractTest$ConcreteFacet[type=FacetAbstractTest$FooFacet]", (String)this.fooFacet.toString());
    }

    public void testUnwrapObjectWhenNull() {
        FacetAbstractTest.assertNull((Object)this.fooFacet.unwrapObject(null));
    }

    public void testUnwrapObjectWhenNotNull() {
        final Object underlyingDomainObject = new Object();
        NakedObjectNoop nakedObject = new NakedObjectNoop(){

            public Object getObject() {
                return underlyingDomainObject;
            }
        };
        FacetAbstractTest.assertEquals((Object)underlyingDomainObject, (Object)this.fooFacet.unwrapObject((NakedObject)nakedObject));
    }

    public void testUnwrapStringWhenNull() {
        FacetAbstractTest.assertNull((Object)this.fooFacet.unwrapString(null));
    }

    public void testUnwrapStringWhenNotNullButNotString() {
        final Object underlyingDomainObject = new Object();
        NakedObjectNoop nakedObject = new NakedObjectNoop(){

            public Object getObject() {
                return underlyingDomainObject;
            }
        };
        FacetAbstractTest.assertNull((Object)this.fooFacet.unwrapString((NakedObject)nakedObject));
    }

    public void testUnwrapStringWhenNotNullAndString() {
        String underlyingDomainObject = "huzzah";
        NakedObjectNoop nakedObject = new NakedObjectNoop(){

            public Object getObject() {
                return "huzzah";
            }
        };
        FacetAbstractTest.assertEquals((String)"huzzah", (String)this.fooFacet.unwrapString((NakedObject)nakedObject));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ConcreteFacet
    extends FacetAbstract {
        public ConcreteFacet(Class<? extends Facet> facetType, FacetHolder holder) {
            super(facetType, holder, false);
        }
    }

    public static interface BarFacet
    extends Facet {
    }

    public static interface FooFacet
    extends Facet {
    }
}

