/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.hide;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.Hidden;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.hide.HiddenAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class HiddenAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private HiddenAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new HiddenAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        HiddenAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testHiddenAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @Hidden
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testHiddenAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @Hidden
            public Collection getOrders() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testHiddenAnnotationPickedUpOnAction() {
        class Customer {
            Customer() {
            }

            @Hidden
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        HiddenAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testHiddenWhenAlwaysAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Hidden(value=org.nakedobjects.applib.annotation.When.ALWAYS)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenFacetAbstract hiddenFacetAbstract = (HiddenFacetAbstract)facet;
        HiddenAnnotationFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)hiddenFacetAbstract.value());
    }

    public void testHiddenWhenNeverAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Hidden(value=org.nakedobjects.applib.annotation.When.NEVER)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenFacetAbstract hiddenFacetAbstract = (HiddenFacetAbstract)facet;
        HiddenAnnotationFacetFactoryTest.assertEquals((Object)When.NEVER, (Object)hiddenFacetAbstract.value());
    }

    public void testHiddenWhenOncePersistedAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Hidden(value=org.nakedobjects.applib.annotation.When.ONCE_PERSISTED)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenFacetAbstract hiddenFacetAbstract = (HiddenFacetAbstract)facet;
        HiddenAnnotationFacetFactoryTest.assertEquals((Object)When.ONCE_PERSISTED, (Object)hiddenFacetAbstract.value());
    }

    public void testDisabledWhenUntilPersistedAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Hidden(value=org.nakedobjects.applib.annotation.When.UNTIL_PERSISTED)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        HiddenFacetAbstract hiddenFacetAbstract = (HiddenFacetAbstract)facet;
        HiddenAnnotationFacetFactoryTest.assertEquals((Object)When.UNTIL_PERSISTED, (Object)hiddenFacetAbstract.value());
    }
}

