/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import java.util.List;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.SaveCallbackFacetFactory;

public class PersistAndSaveCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private SaveCallbackFacetFactory saveFacetFactory;
    private PersistCallbackFacetFactory persistFacetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.saveFacetFactory = new SaveCallbackFacetFactory();
        this.persistFacetFactory = new PersistCallbackFacetFactory();
    }

    public void testFeatureTypes() {
    }

    protected void tearDown() throws Exception {
        this.saveFacetFactory = null;
        this.persistFacetFactory = null;
        super.tearDown();
    }

    public void testSavingAndPersistingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void saving() {
            }

            public void persisting() {
            }
        }
        Method saveMethod = this.findMethod(Customer.class, "saving");
        Method persistMethod = this.findMethod(Customer.class, "persisting");
        this.saveFacetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.persistFacetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistingCallbackFacet.class);
        PersistAndSaveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistingCallbackFacetViaMethod));
        PersistingCallbackFacetViaMethod persistingCallbackFacetViaMethod = (PersistingCallbackFacetViaMethod)facet;
        List methods = persistingCallbackFacetViaMethod.getMethods();
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)methods.contains(saveMethod));
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)methods.contains(persistMethod));
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(saveMethod));
    }

    public void testSavedAndPersistedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void saved() {
            }

            public void persisted() {
            }
        }
        Method saveMethod = this.findMethod(Customer.class, "saved");
        Method persistMethod = this.findMethod(Customer.class, "persisted");
        this.saveFacetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.persistFacetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistedCallbackFacet.class);
        PersistAndSaveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistedCallbackFacetViaMethod));
        PersistedCallbackFacetViaMethod persistedCallbackFacetViaMethod = (PersistedCallbackFacetViaMethod)facet;
        List methods = persistedCallbackFacetViaMethod.getMethods();
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)methods.contains(saveMethod));
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)methods.contains(persistMethod));
        PersistAndSaveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(saveMethod));
    }
}

