/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdateCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.UpdatingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class UpdateCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private UpdateCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new UpdateCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        UpdateCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        UpdateCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        UpdateCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        UpdateCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        UpdateCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testUpdatingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void updating() {
            }
        }
        Method method = this.findMethod(Customer.class, "updating");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(UpdatingCallbackFacet.class);
        UpdateCallbackFacetFactoryTest.assertNotNull((Object)facet);
        UpdateCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof UpdatingCallbackFacetViaMethod));
        UpdatingCallbackFacetViaMethod updatingCallbackFacetViaMethod = (UpdatingCallbackFacetViaMethod)facet;
        UpdateCallbackFacetFactoryTest.assertEquals((Object)method, updatingCallbackFacetViaMethod.getMethods().get(0));
        UpdateCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testUpdatedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void updated() {
            }
        }
        Method method = this.findMethod(Customer.class, "updated");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(UpdatedCallbackFacet.class);
        UpdateCallbackFacetFactoryTest.assertNotNull((Object)facet);
        UpdateCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof UpdatedCallbackFacetViaMethod));
        UpdatedCallbackFacetViaMethod updatedCallbackFacetViaMethod = (UpdatedCallbackFacetViaMethod)facet;
        UpdateCallbackFacetFactoryTest.assertEquals((Object)method, updatedCallbackFacetViaMethod.getMethods().get(0));
        UpdateCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

