/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.encodable;

import org.nakedobjects.applib.adapters.EncoderDecoder;
import org.nakedobjects.applib.annotation.Encodable;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.internal.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodableFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class EncodableFacetFactoryTest
extends AbstractFacetFactoryTest {
    private EncodableAnnotationFacetFactory facetFactory;
    private PropertiesConfiguration propertiesConfiguration;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new EncodableAnnotationFacetFactory();
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.facetFactory.setNakedObjectConfiguration((NakedObjectConfiguration)this.propertiesConfiguration);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        EncodableFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        EncodableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        EncodableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        EncodableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        EncodableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFacetPickedUp() {
        this.facetFactory.process(MyEncodableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacet facet = (EncodableFacet)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertNotNull((Object)facet);
        EncodableFacetFactoryTest.assertTrue((boolean)(facet instanceof EncodableFacetAbstract));
    }

    public void testFacetFacetHolderStored() {
        this.facetFactory.process(MyEncodableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract valueFacet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertEquals((Object)this.facetHolder, (Object)valueFacet.getFacetHolder());
    }

    public void testNoMethodsRemoved() {
        this.facetFactory.process(MyEncodableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.assertNoMethodsRemoved();
    }

    public void testEncodeableUsingEncoderDecoderName() {
        this.facetFactory.process(MyEncodableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract encodeableFacet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertEquals(MyEncodableUsingEncoderDecoderName.class, (Object)encodeableFacet.getEncoderDecoderClass());
    }

    public void testEncodeableUsingEncoderDecoderClass() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract encodeableFacet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertEquals(MyEncodeableUsingEncoderDecoderClass.class, (Object)encodeableFacet.getEncoderDecoderClass());
    }

    public void testEncodeableMustBeAEncoderDecoder() {
    }

    public void testEncodeableHaveANoArgConstructor() {
        this.facetFactory.process(MyEncodeableWithoutNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract encodeableFacet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertNull((Object)encodeableFacet);
    }

    public void testEncodeableHaveAPublicNoArgConstructor() {
        this.facetFactory.process(MyEncodeableWithoutPublicNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract encodeableFacet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertNull((Object)encodeableFacet);
    }

    public void testEncoderDecoderNameCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.encoderDecoder." + this.canonical("org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration") + ".encoderDecoderName", "org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration");
        this.facetFactory.process(MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract facet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertNotNull((Object)facet);
        EncodableFacetFactoryTest.assertEquals(MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration.class, (Object)facet.getEncoderDecoderClass());
    }

    public void testNonAnnotatedEncodeableCanPickUpEncoderDecoderFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.encoderDecoder." + this.canonical("org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration") + ".encoderDecoderName", "org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration");
        this.facetFactory.process(NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodableFacetAbstract facet = (EncodableFacetAbstract)this.facetHolder.getFacet(EncodableFacet.class);
        EncodableFacetFactoryTest.assertNotNull((Object)facet);
        EncodableFacetFactoryTest.assertEquals(NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration.class, (Object)facet.getEncoderDecoderClass());
    }

    private String canonical(String className) {
        return className.replace('$', '.');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration
    extends EncoderDecoderNoop<NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodable
    public static class MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration
    extends EncoderDecoderNoop<MyEncodableWithEncoderDecoderSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodable(encoderDecoderClass=MyEncodeableWithoutPublicNoArgConstructor.class)
    public static class MyEncodeableWithoutPublicNoArgConstructor
    extends EncoderDecoderNoop<MyEncodeableWithoutPublicNoArgConstructor> {
        MyEncodeableWithoutPublicNoArgConstructor() {
        }

        public MyEncodeableWithoutPublicNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodable(encoderDecoderClass=MyEncodeableWithoutNoArgConstructor.class)
    public static class MyEncodeableWithoutNoArgConstructor
    extends EncoderDecoderNoop<MyEncodeableWithoutNoArgConstructor> {
        public MyEncodeableWithoutNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodable(encoderDecoderClass=MyEncodeableUsingEncoderDecoderClass.class)
    public static class MyEncodeableUsingEncoderDecoderClass
    extends EncoderDecoderNoop<MyEncodeableUsingEncoderDecoderClass> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodable(encoderDecoderName="org.nakedobjects.metamodel.facets.object.encodable.EncodableFacetFactoryTest$MyEncodableUsingEncoderDecoderName")
    public static class MyEncodableUsingEncoderDecoderName
    extends EncoderDecoderNoop<MyEncodableUsingEncoderDecoderName> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EncoderDecoderNoop<T>
    implements EncoderDecoder<T> {
        EncoderDecoderNoop() {
        }

        public T fromEncodedString(String encodedString) {
            return null;
        }

        public String toEncodedString(T toEncode) {
            return null;
        }
    }
}

