/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.ident.plural;

import org.nakedobjects.applib.annotation.Plural;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacet;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class PluralAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private PluralAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new PluralAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        PluralAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        PluralAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        PluralAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        PluralAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        PluralAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testPluralAnnotationMethodPickedUpOnClass() {
        @Plural(value="Some plural name")
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PluralFacet.class);
        PluralAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        PluralAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof PluralFacetAnnotation));
        PluralFacetAnnotation pluralFacet = (PluralFacetAnnotation)facet;
        PluralAnnotationFacetFactoryTest.assertEquals((String)"Some plural name", (String)pluralFacet.value());
        this.assertNoMethodsRemoved();
    }
}

