/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.ident.singular;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.object.ident.singular.NamedFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.ident.singular.SingularMethodFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class SingularMethodFacetFactoryTest
extends AbstractFacetFactoryTest {
    private SingularMethodFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new SingularMethodFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        SingularMethodFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        SingularMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        SingularMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        SingularMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        SingularMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testSingularNameMethodPickedUpOnClassAndMethodRemoved() {
        Method singularNameMethod = this.findMethod(Customer.class, "singularName");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        SingularMethodFacetFactoryTest.assertNotNull((Object)facet);
        SingularMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetViaMethod));
        NamedFacetViaMethod namedFacetViaMethod = (NamedFacetViaMethod)facet;
        SingularMethodFacetFactoryTest.assertEquals((String)"Some name", (String)namedFacetViaMethod.value());
        SingularMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(singularNameMethod));
    }

    public static class Customer {
        public static String singularName() {
            return "Some name";
        }
    }
}

