/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.ident.title;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacet;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacetViaTitleMethod;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacetViaToStringMethod;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleMethodFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class TitleMethodFacetFactoryTest
extends AbstractFacetFactoryTest {
    private TitleMethodFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new TitleMethodFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        TitleMethodFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        TitleMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        TitleMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        TitleMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        TitleMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testTitleMethodPickedUpOnClassAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String title() {
                return "Some title";
            }
        }
        Method titleMethod = this.findMethod(Customer.class, "title");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TitleFacet.class);
        TitleMethodFacetFactoryTest.assertNotNull((Object)facet);
        TitleMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof TitleFacetViaTitleMethod));
        TitleFacetViaTitleMethod titleFacetViaTitleMethod = (TitleFacetViaTitleMethod)facet;
        TitleMethodFacetFactoryTest.assertEquals((Object)titleMethod, titleFacetViaTitleMethod.getMethods().get(0));
        TitleMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(titleMethod));
    }

    public void testToStringMethodPickedUpOnClassAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String toString() {
                return "Some title via toString";
            }
        }
        Method toStringMethod = this.findMethod(Customer.class, "toString");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TitleFacet.class);
        TitleMethodFacetFactoryTest.assertNotNull((Object)facet);
        TitleMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof TitleFacetViaToStringMethod));
        TitleFacetViaToStringMethod titleFacetViaTitleMethod = (TitleFacetViaToStringMethod)facet;
        TitleMethodFacetFactoryTest.assertEquals((Object)toStringMethod, titleFacetViaTitleMethod.getMethods().get(0));
        TitleMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(toStringMethod));
    }

    public void testTitleFacetMethodUsingToStringIsClassifiedAsANoop() {
        TitleMethodFacetFactoryTest.assertTrue((boolean)new TitleFacetViaToStringMethod(null, (FacetHolder)this.facetHolder).isNoop());
    }

    public void testNoExplicitTitleOrToStringMethod() {
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        TitleMethodFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(TitleFacet.class));
        this.assertNoMethodsRemoved();
    }
}

