/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.notpersistable;

import org.nakedobjects.applib.annotation.NotPersistable;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.notpersistable.InitiatedBy;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class NotPersistableAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private NotPersistableAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new NotPersistableAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        NotPersistableAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        NotPersistableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        NotPersistableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        NotPersistableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        NotPersistableAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testNotPersistableAnnotationPickedUpOnClassAndDefaultsToUserOrProgram() {
        @NotPersistable
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistableFacet.class);
        NotPersistableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistableFacetAnnotation));
        NotPersistableFacetAnnotation notPersistableFacetAnnotation = (NotPersistableFacetAnnotation)facet;
        InitiatedBy value = notPersistableFacetAnnotation.value();
        NotPersistableAnnotationFacetFactoryTest.assertEquals((Object)InitiatedBy.USER_OR_PROGRAM, (Object)value);
        this.assertNoMethodsRemoved();
    }

    public void testNotPersistableAnnotationUserOrProgramPickedUpOn() {
        @NotPersistable(value=NotPersistable.By.USER_OR_PROGRAM)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistableFacet.class);
        NotPersistableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistableFacetAnnotation));
        NotPersistableFacetAnnotation notPersistableFacetAnnotation = (NotPersistableFacetAnnotation)facet;
        InitiatedBy value = notPersistableFacetAnnotation.value();
        NotPersistableAnnotationFacetFactoryTest.assertEquals((Object)InitiatedBy.USER_OR_PROGRAM, (Object)value);
        this.assertNoMethodsRemoved();
    }

    public void testNotPersistableAnnotationUserPickedUpOn() {
        @NotPersistable(value=NotPersistable.By.USER)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistableFacet.class);
        NotPersistableAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistableAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistableFacetAnnotation));
        NotPersistableFacetAnnotation notPersistableFacetAnnotation = (NotPersistableFacetAnnotation)facet;
        InitiatedBy value = notPersistableFacetAnnotation.value();
        NotPersistableAnnotationFacetFactoryTest.assertEquals((Object)InitiatedBy.USER, (Object)value);
        this.assertNoMethodsRemoved();
    }
}

