/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.notpersistable;

import org.nakedobjects.applib.marker.NonPersistable;
import org.nakedobjects.applib.marker.ProgramPersistable;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.notpersistable.InitiatedBy;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableFacetMarkerInterface;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableMarkerInterfacesFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class NotPersistableMarkerInterfaceFacetFactoryTest
extends AbstractFacetFactoryTest {
    private NotPersistableMarkerInterfacesFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new NotPersistableMarkerInterfacesFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        NotPersistableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        NotPersistableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        NotPersistableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        NotPersistableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        NotPersistableMarkerInterfaceFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testProgramPersistableMeansNotPersistableByUser() {
        class Customer
        implements ProgramPersistable {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistableFacet.class);
        NotPersistableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistableFacetMarkerInterface));
        NotPersistableFacetMarkerInterface notPersistableFacetMarkerInterface = (NotPersistableFacetMarkerInterface)facet;
        InitiatedBy value = notPersistableFacetMarkerInterface.value();
        NotPersistableMarkerInterfaceFacetFactoryTest.assertEquals((Object)InitiatedBy.USER, (Object)value);
        this.assertNoMethodsRemoved();
    }

    public void testNotPersistable() {
        class Customer
        implements NonPersistable {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NotPersistableFacet.class);
        NotPersistableMarkerInterfaceFacetFactoryTest.assertNotNull((Object)facet);
        NotPersistableMarkerInterfaceFacetFactoryTest.assertTrue((boolean)(facet instanceof NotPersistableFacetMarkerInterface));
        NotPersistableFacetMarkerInterface notPersistableFacetMarkerInterface = (NotPersistableFacetMarkerInterface)facet;
        InitiatedBy value = notPersistableFacetMarkerInterface.value();
        NotPersistableMarkerInterfaceFacetFactoryTest.assertEquals((Object)InitiatedBy.USER_OR_PROGRAM, (Object)value);
        this.assertNoMethodsRemoved();
    }
}

