/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.actionorder;

import org.nakedobjects.applib.annotation.ActionOrder;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.ordering.actionorder.ActionOrderAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.ordering.actionorder.ActionOrderFacet;
import org.nakedobjects.metamodel.facets.ordering.actionorder.ActionOrderFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ActionOrderAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ActionOrderAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ActionOrderAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ActionOrderAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ActionOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ActionOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ActionOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ActionOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testActionOrderAnnotationPickedUpOnClass() {
        @ActionOrder(value="foo,bar")
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionOrderFacet.class);
        ActionOrderAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ActionOrderAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionOrderFacetAnnotation));
        ActionOrderFacetAnnotation actionOrderFacetAnnotation = (ActionOrderFacetAnnotation)facet;
        ActionOrderAnnotationFacetFactoryTest.assertEquals((String)"foo,bar", (String)actionOrderFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }
}

