/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.memberorder;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.MemberOrder;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderAnnotationFacetFactoryTest;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacet;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class MemberOrderAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private MemberOrderAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new MemberOrderAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        MemberOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        MemberOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testMemberOrderAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @MemberOrder(sequence="1")
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MemberOrderFacet.class);
        MemberOrderAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MemberOrderFacetAnnotation));
        MemberOrderFacetAnnotation memberOrderFacetAnnotation = (MemberOrderFacetAnnotation)facet;
        MemberOrderAnnotationFacetFactoryTest.assertEquals((String)"1", (String)memberOrderFacetAnnotation.sequence());
        this.assertNoMethodsRemoved();
    }

    public void testMemberOrderAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @MemberOrder(sequence="2")
            public Collection getOrders() {
                return null;
            }

            public void addToOrders(1Order o) {
            }
        }
        Method method = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MemberOrderFacet.class);
        MemberOrderAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MemberOrderFacetAnnotation));
        MemberOrderFacetAnnotation memberOrderFacetAnnotation = (MemberOrderFacetAnnotation)facet;
        MemberOrderAnnotationFacetFactoryTest.assertEquals((String)"2", (String)memberOrderFacetAnnotation.sequence());
        this.assertNoMethodsRemoved();
    }

    public void testMemberOrderAnnotationPickedUpOnAction() {
        class Customer {
            Customer() {
            }

            @MemberOrder(sequence="3")
            public void someAction() {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MemberOrderFacet.class);
        MemberOrderAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MemberOrderAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MemberOrderFacetAnnotation));
        MemberOrderFacetAnnotation memberOrderFacetAnnotation = (MemberOrderFacetAnnotation)facet;
        MemberOrderAnnotationFacetFactoryTest.assertEquals((String)"3", (String)memberOrderFacetAnnotation.sequence());
        this.assertNoMethodsRemoved();
    }
}

