/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.specification;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.propparam.specification.MustSatisfySpecificationFacet;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationAlwaysSatisfied;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationNeverSatisfied;
import org.nakedobjects.metamodel.facets.propparam.specification.Utils;
import org.nakedobjects.metamodel.interactions.PropertyModifyContext;
import org.nakedobjects.metamodel.interactions.ValidityContext;
import org.nakedobjects.metamodel.spec.identifier.Identified;

@RunWith(value=JMock.class)
public class MustSatisfySpecificationValidatingInteractionTest {
    private final Mockery mockery = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };
    private MustSatisfySpecificationFacet facetForSpecificationAlwaysSatisfied;
    private MustSatisfySpecificationFacet facetForSpecificationNeverSatisfied;
    private FacetHolder mockHolder;
    private PropertyModifyContext mockContext;
    private NakedObject mockProposedNakedObject;
    private Object mockProposedObject;
    private SpecificationAlwaysSatisfied specificationAlwaysSatisfied;
    private SpecificationNeverSatisfied specificationNeverSatisfied;

    @Before
    public void setUp() throws Exception {
        this.mockHolder = (FacetHolder)this.mockery.mock(Identified.class);
        this.specificationAlwaysSatisfied = new SpecificationAlwaysSatisfied();
        this.specificationNeverSatisfied = new SpecificationNeverSatisfied();
        this.facetForSpecificationAlwaysSatisfied = new MustSatisfySpecificationFacet(Utils.listOf(this.specificationAlwaysSatisfied), this.mockHolder);
        this.facetForSpecificationNeverSatisfied = new MustSatisfySpecificationFacet(Utils.listOf(this.specificationNeverSatisfied), this.mockHolder);
        this.mockContext = (PropertyModifyContext)this.mockery.mock(PropertyModifyContext.class);
        this.mockProposedNakedObject = (NakedObject)this.mockery.mock(NakedObject.class, "proposed");
        this.mockProposedObject = this.mockery.mock(Object.class, "proposedObject");
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((PropertyModifyContext)this.one(MustSatisfySpecificationValidatingInteractionTest.this.mockContext)).getProposed();
                this.will(2.returnValue((Object)MustSatisfySpecificationValidatingInteractionTest.this.mockProposedNakedObject));
                ((NakedObject)this.one(MustSatisfySpecificationValidatingInteractionTest.this.mockProposedNakedObject)).getObject();
                this.will(2.returnValue((Object)MustSatisfySpecificationValidatingInteractionTest.this.mockProposedObject));
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.mockHolder = null;
        this.facetForSpecificationAlwaysSatisfied = null;
        this.facetForSpecificationNeverSatisfied = null;
        this.mockContext = null;
    }

    @Test
    public void validatesWhenSpecificationDoesNotVeto() {
        String reason = this.facetForSpecificationAlwaysSatisfied.invalidates((ValidityContext)this.mockContext);
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void invalidatesWhenSpecificationVetoes() {
        String reason = this.facetForSpecificationNeverSatisfied.invalidates((ValidityContext)this.mockContext);
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Object)"not satisfied"));
    }
}

