/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.typicallength;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.TypicalLength;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacet;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class TypicalLengthAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private TypicalLengthAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new TypicalLengthAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        TypicalLengthAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        TypicalLengthAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        TypicalLengthAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        TypicalLengthAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        TypicalLengthAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testTypicalLengthAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @TypicalLength(value=30)
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypicalLengthFacet.class);
        TypicalLengthAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypicalLengthAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypicalLengthFacetAnnotation));
        TypicalLengthFacetAnnotation typicalLengthFacetAnnotation = (TypicalLengthFacetAnnotation)facet;
        TypicalLengthAnnotationFacetFactoryTest.assertEquals((int)30, (int)typicalLengthFacetAnnotation.value());
    }

    public void testTypicalLengthAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@TypicalLength(value=20) int foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypicalLengthFacet.class);
        TypicalLengthAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        TypicalLengthAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof TypicalLengthFacetAnnotation));
        TypicalLengthFacetAnnotation typicalLengthFacetAnnotation = (TypicalLengthFacetAnnotation)facet;
        TypicalLengthAnnotationFacetFactoryTest.assertEquals((int)20, (int)typicalLengthFacetAnnotation.value());
    }
}

