/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.mask;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskEvaluator;

@RunWith(value=Parameterized.class)
public class MaskEvaluatorTest {
    private MaskEvaluator maskEvaluator;
    private Locale previousLocale = Locale.getDefault();
    private final String mask;
    private final String proposed;
    private final boolean expected;

    @Parameterized.Parameters
    public static Collection data() {
        return Arrays.asList({"AAA", "aby", true}, {"A", "A", true}, {"A", "Z", true}, {"A", "a", true}, {"A", "z", true}, {"A", "0", true}, {"A", "9", true}, {"A", "@", false}, {"A", "~", false}, {"a", "A", true}, {"a", "Z", true}, {"a", "a", true}, {"a", "z", true}, {"a", "0", true}, {"a", "9", true}, {"a", " ", true}, {"a", "~", false}, {"9", "z", false}, {"9", "0", true}, {"9", "9", true}, {"9", " ", true}, {"9", "~", false}, {"&", "A", true}, {"&", "Z", true}, {"&", "a", true}, {"&", "z", true}, {"&", "9", false}, {"?", "A", true}, {"?", "Z", true}, {"?", "a", true}, {"?", "z", true}, {"U", "A", true}, {"U", "Z", true}, {"U", "a", false}, {"L", "a", true}, {"L", "z", true}, {"L", "A", false}, {"#", "0", true}, {"#", "9", true}, {"#", "X", false}, {"#", "#", false}, {",", ",", true}, {":", ":", true}, {":", "X", false}, {"/", "/", true}, {"/", "X", false}, {"##", "23", true});
    }

    @Before
    public void setUp() {
        this.previousLocale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
    }

    @After
    public void tearDown() {
        Locale.setDefault(this.previousLocale);
    }

    public MaskEvaluatorTest(String mask, String proposed, boolean expected) {
        this.mask = mask;
        this.proposed = proposed;
        this.expected = expected;
    }

    @Test
    public void all() {
        Assert.assertThat((Object)new MaskEvaluator(this.mask).evaluate(this.proposed), (Matcher)CoreMatchers.is((Object)this.expected));
    }
}

