/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.regex;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.RegEx;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class RegExAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private RegExAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new RegExAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        RegExAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        RegExAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testRegExAnnotationPickedUpOnClass() {
        @RegEx(validation="^A.*", caseSensitive=false)
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RegExFacet.class);
        RegExAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof RegExFacetAnnotation));
        RegExFacetAnnotation regExFacet = (RegExFacetAnnotation)facet;
        RegExAnnotationFacetFactoryTest.assertEquals((String)"^A.*", (String)regExFacet.validation());
        RegExAnnotationFacetFactoryTest.assertEquals((boolean)false, (boolean)regExFacet.caseSensitive());
    }

    public void testRegExAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @RegEx(validation="^A.*", caseSensitive=false)
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RegExFacet.class);
        RegExAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof RegExFacetAnnotation));
        RegExFacetAnnotation regExFacet = (RegExFacetAnnotation)facet;
        RegExAnnotationFacetFactoryTest.assertEquals((String)"^A.*", (String)regExFacet.validation());
        RegExAnnotationFacetFactoryTest.assertEquals((boolean)false, (boolean)regExFacet.caseSensitive());
    }

    public void testRegExAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@RegEx(validation="^A.*", caseSensitive=false) String foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{String.class});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RegExFacet.class);
        RegExAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        RegExAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof RegExFacetAnnotation));
        RegExFacetAnnotation regExFacet = (RegExFacetAnnotation)facet;
        RegExAnnotationFacetFactoryTest.assertEquals((String)"^A.*", (String)regExFacet.validation());
        RegExAnnotationFacetFactoryTest.assertEquals((boolean)false, (boolean)regExFacet.caseSensitive());
    }

    public void testRegExAnnotationIgnoredForNonStringsProperty() {
        class Customer {
            Customer() {
            }

            @RegEx(validation="^A.*", caseSensitive=false)
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method method = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        RegExAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(RegExFacet.class));
    }

    public void testRegExAnnotationIgnoredForPrimitiveOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@RegEx(validation="^A.*", caseSensitive=false) int foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        RegExAnnotationFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(RegExFacet.class));
    }
}

