/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.java5;

import java.lang.reflect.Method;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.java5.Customer;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.java5.ImperativeFacetUtils;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;

@RunWith(value=JMock.class)
public class ImperativeFacetUtilsTest {
    private Mockery context = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };
    private NakedObjectMember mockNakedObjectMember;
    private Method method;

    @Before
    public void setUp() throws Exception {
        this.mockNakedObjectMember = (NakedObjectMember)this.context.mock(NakedObjectMember.class);
        this.method = Customer.class.getDeclaredMethod("getFirstName", new Class[0]);
    }

    @Test
    public void getImperativeFacetsWhenHasNone() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectMember)this.one(ImperativeFacetUtilsTest.this.mockNakedObjectMember)).getFacets((Filter)this.with(2.any(Filter.class)));
                this.will(2.returnValue((Object)new Facet[0]));
            }
        });
        ImperativeFacetUtils.ImperativeFacetFlags flags = ImperativeFacetUtils.getImperativeFacetFlags((NakedObjectMember)this.mockNakedObjectMember, (Method)this.method);
        Assert.assertThat((Object)flags, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)flags.impliesResolve(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)flags.impliesObjectChanged(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void getImperativeFacetsWhenHasOneImperativeFacet() throws Exception {
        final ImperativeFacet imperativeFacet = null;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectMember)this.one(ImperativeFacetUtilsTest.this.mockNakedObjectMember)).getFacets((Filter)this.with(3.any(Filter.class)));
                this.will(3.returnValue((Object)new Facet[]{(Facet)imperativeFacet}));
            }
        });
        ImperativeFacetUtils.ImperativeFacetFlags flags = ImperativeFacetUtils.getImperativeFacetFlags((NakedObjectMember)this.mockNakedObjectMember, (Method)this.method);
        Assert.assertThat((Object)flags, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }
}

