/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.math.BigDecimal;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.BigDecimalValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class BigDecimalValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private BigDecimalValueSemanticsProvider value;
    private BigDecimal bigDecimal;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(BigDecimalValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.decimal");
                this.will(1.returnValue(null));
            }
        });
        this.bigDecimal = new BigDecimal("34132.199");
        this.allowMockAdapterToReturn(this.bigDecimal);
        this.holder = new FacetHolderImpl();
        this.value = new BigDecimalValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testParseValidString() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "2142342334");
        Assert.assertEquals((Object)new BigDecimal(2142342334L), (Object)newValue);
    }

    @Test
    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry(null, "214xxx2342334");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"34,132.199", (Object)this.value.displayTitleOf((Object)this.bigDecimal));
    }

    @Test
    public void testEncode() {
        Assert.assertEquals((Object)"34132.199", (Object)this.value.toEncodedString((Object)this.bigDecimal));
    }

    @Test
    public void testDecode() throws Exception {
        Object newValue = this.value.fromEncodedString("4322.89991");
        Assert.assertEquals((Object)new BigDecimal("4322.89991"), (Object)newValue);
    }
}

