/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.ByteValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ByteWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class ByteValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private ByteValueSemanticsProviderAbstract value;
    private Byte byteObj;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.byteObj = new Byte(102);
        this.allowMockAdapterToReturn(this.byteObj);
        this.holder = new FacetHolderImpl();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ByteValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.byte");
                this.will(1.returnValue(null));
            }
        });
        this.value = new ByteWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testParseValidString() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "21");
        Assert.assertEquals((Object)new Byte(21), (Object)parsed);
    }

    @Test
    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry((Object)this.mockAdapter, "xs21z4xxx23");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() throws Exception {
        Assert.assertEquals((Object)"102", (Object)this.value.displayTitleOf((Object)this.byteObj));
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"102", (Object)this.value.toEncodedString((Object)this.byteObj));
    }

    @Test
    public void testDecode() throws Exception {
        Object parsed = this.value.fromEncodedString("-91");
        Assert.assertEquals((Object)new Byte(-91), (Object)parsed);
    }
}

