/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.adapters.EncodingException;
import org.nakedobjects.applib.value.Date;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.DateValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class DateValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private DateValueSemanticsProvider adapter;
    private Object date;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(DateValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.date");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.setupSpecification(Date.class);
        this.date = new Date(2001, 2, 4);
        this.holder = new FacetHolderImpl();
        this.adapter = new DateValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    @Test
    public void testDateAsEncodedString() throws Exception {
        Assert.assertEquals((Object)"20010204", (Object)new String(this.adapter.toEncodedString(this.date)));
    }

    @Test
    public void testParseEntryOfDaysAfterDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "+7");
        Assert.assertEquals((Object)new Date(2001, 2, 11), (Object)parsed);
    }

    @Test
    public void testParseEntryOfDaysAfterToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "+5");
        Assert.assertEquals((Object)new Date(2003, 8, 22), (Object)parsed);
    }

    @Test
    public void testParseEntryOfDaysBeforeDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "-7");
        Assert.assertEquals((Object)new Date(2001, 1, 28), (Object)parsed);
    }

    @Test
    public void testParseEntryOfDaysBeforeToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "-5");
        Assert.assertEquals((Object)new Date(2003, 8, 12), (Object)parsed);
    }

    @Test
    public void testParseEntryOfKeywordToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "today");
        Assert.assertEquals((Object)new Date(2003, 8, 17), (Object)parsed);
    }

    @Test
    public void testParseEntryOfWeeksAfterDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "+3w");
        Assert.assertEquals((Object)new Date(2001, 2, 25), (Object)parsed);
    }

    @Test
    public void testParseEntryOfWeeksAfterToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "+4w");
        Assert.assertEquals((Object)new Date(2003, 9, 14), (Object)parsed);
    }

    @Test
    public void testParseEntryOfWeeksBeforeDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "-3w");
        Assert.assertEquals((Object)new Date(2001, 1, 14), (Object)parsed);
    }

    @Test
    public void testParseEntryOfWeeksBeforeToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "-4w");
        Assert.assertEquals((Object)new Date(2003, 7, 20), (Object)parsed);
    }

    @Test
    public void testParseEntryOfMonthsAfterDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "+3m");
        Assert.assertEquals((Object)new Date(2001, 5, 4), (Object)parsed);
    }

    @Test
    public void testParseEntryOfMonthsAfterToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "+4m");
        Assert.assertEquals((Object)new Date(2003, 12, 17), (Object)parsed);
    }

    @Test
    public void testParseEntryOfMonthsBeforeDate() throws Exception {
        Object parsed = this.adapter.parseTextEntry(this.date, "-3m");
        Assert.assertEquals((Object)new Date(2000, 11, 4), (Object)parsed);
    }

    @Test
    public void testParseEntryOfMonthsBeforeToToday() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "-4m");
        Assert.assertEquals((Object)new Date(2003, 4, 17), (Object)parsed);
    }

    @Test
    public void testRestoreOfInvalidDatal() throws Exception {
        try {
            this.adapter.fromEncodedString("2003may12");
            Assert.fail();
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
    }
}

