/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.DoubleWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class DoubleValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private Double doubleObj;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(DoubleValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.double");
                this.will(1.returnValue(null));
            }
        });
        this.holder = new FacetHolderImpl();
        this.setValue((ValueSemanticsProviderAbstract)new DoubleWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext));
        this.doubleObj = new Double(32.5);
        this.allowMockAdapterToReturn(this.doubleObj);
    }

    @Test
    public void testValue() {
        Assert.assertEquals((Object)"32.5", (Object)this.getValue().displayTitleOf((Object)this.doubleObj));
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.getValue().parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"35,000,000", (Object)this.getValue().displayTitleOf((Object)3.5E7));
    }

    @Test
    public void testParse() throws Exception {
        Object newValue = this.getValue().parseTextEntry(null, "120.56");
        Assert.assertEquals((double)120.56, (double)((Double)newValue), (double)0.0);
    }

    @Test
    public void testParse2() throws Exception {
        Object newValue = this.getValue().parseTextEntry(null, "1,20.0");
        Assert.assertEquals((double)120.0, (double)((Double)newValue), (double)0.0);
    }
}

