/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.adapter.oid;

import java.io.IOException;
import java.io.Serializable;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.oid.Oid;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregatedOid
implements Oid,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Oid parentOid;
    private final String fieldName;
    private AggregatedOid previous;
    private int cachedHashCode;

    private static <T> T ensureNotNull(T oid, String message) {
        Assert.assertNotNull(message, oid);
        return oid;
    }

    public AggregatedOid(Oid oid, String id) {
        Assert.assertNotNull("Field required", id);
        this.parentOid = oid;
        this.fieldName = id;
        this.initialized();
    }

    public AggregatedOid(Oid oid, Identifier identifier) {
        this(oid, AggregatedOid.ensureNotNull(identifier, "Field required").getMemberName());
    }

    public AggregatedOid(DataInputExtended input) throws IOException {
        this.parentOid = input.readEncodable(Oid.class);
        this.fieldName = input.readUTF();
        this.initialized();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeEncodable(this.parentOid);
        output.writeUTF(this.fieldName);
    }

    private void initialized() {
        this.cacheState();
    }

    public Oid getParentOid() {
        return this.parentOid;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void makePersistent() {
        this.previous = new AggregatedOid(this.parentOid, this.fieldName);
        this.cacheState();
    }

    @Override
    public Oid getPrevious() {
        return this.previous;
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public void clearPrevious() {
    }

    @Override
    public void copyFrom(Oid oid) {
        throw new NotYetImplementedException();
    }

    @Override
    public boolean isTransient() {
        return this.parentOid.isTransient();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.equals((AggregatedOid)other);
    }

    public boolean equals(AggregatedOid other) {
        return other.parentOid.equals(this.parentOid) && other.fieldName.equals(this.fieldName);
    }

    public int hashCode() {
        this.cacheState();
        return this.cachedHashCode;
    }

    private void cacheState() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.parentOid.hashCode();
        this.cachedHashCode = hashCode = 37 * hashCode + this.fieldName.hashCode();
    }

    public String toString() {
        return "AOID[" + this.parentOid + "," + this.fieldName + "]";
    }
}

