/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.adapter.version;

import java.io.IOException;
import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.adapter.version.VersionUserAndTimeAbstract;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;

public class SerialNumberVersion
extends VersionUserAndTimeAbstract {
    private final long versionNumber;

    public SerialNumberVersion(long number, String user, Date time) {
        super(user, time);
        this.versionNumber = number;
        this.initialized();
    }

    public SerialNumberVersion(DataInputExtended input) throws IOException {
        super(input);
        this.versionNumber = input.readLong();
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeLong(this.versionNumber);
    }

    private void initialized() {
    }

    public long getSequence() {
        return this.versionNumber;
    }

    public String sequence() {
        return Long.toString(this.versionNumber, 16);
    }

    public boolean different(Version version) {
        if (version instanceof SerialNumberVersion) {
            SerialNumberVersion other = (SerialNumberVersion)version;
            return this.versionNumber != other.versionNumber;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SerialNumberVersion) {
            return !this.different((SerialNumberVersion)obj);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.versionNumber ^ this.versionNumber >>> 32);
    }

    public String toString() {
        return "SerialNumberVersion#" + this.versionNumber + " " + ToString.timestamp(this.getTime());
    }
}

