/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.authentication;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataOutputExtended;
import org.nakedobjects.metamodel.commons.lang.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticationSessionAbstract
implements AuthenticationSession,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> roles = new ArrayList<String>();
    private final String code;
    private final Map<String, Object> attributeByName = new HashMap<String, Object>();

    public AuthenticationSessionAbstract(String name, String code) {
        this(name, Collections.EMPTY_LIST, code);
    }

    public AuthenticationSessionAbstract(String name, List<String> roles, String code) {
        this.name = name;
        this.roles.addAll(roles);
        this.code = code;
        this.initialized();
    }

    public AuthenticationSessionAbstract(DataInputExtended input) throws IOException {
        this.name = input.readUTF();
        this.roles.addAll(Arrays.asList(input.readUTFs()));
        this.code = input.readUTF();
        this.initialized();
    }

    @Override
    public void encode(DataOutputExtended output) throws IOException {
        output.writeUTF(this.getUserName());
        output.writeUTFs(this.roles.toArray(new String[0]));
        output.writeUTF(this.code);
    }

    private void initialized() {
    }

    @Override
    public String getUserName() {
        return this.name;
    }

    @Override
    public boolean hasUserNameOf(String userName) {
        return userName == null ? false : userName.equals(this.getUserName());
    }

    @Override
    public List<String> getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    @Override
    public String getValidationCode() {
        return this.code;
    }

    @Override
    public Object getAttribute(String attributeName) {
        return this.attributeByName.get(attributeName);
    }

    @Override
    public void setAttribute(String attributeName, Object attribute) {
        this.attributeByName.put(attributeName, attribute);
    }

    public String toString() {
        return new ToString(this).append("name", this.getUserName()).append("code", this.getValidationCode()).toString();
    }
}

