/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtended;
import org.nakedobjects.metamodel.commons.encoding.DataInputExtendedDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugDataInputExtended
extends DataInputExtendedDecorator {
    private static final Logger LOG = Logger.getLogger(DebugDataInputExtended.class);

    public DebugDataInputExtended(DataInputExtended input) {
        super(input);
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean b = super.readBoolean();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("boolean: " + b));
        }
        return b;
    }

    @Override
    public byte readByte() throws IOException {
        byte b = super.readByte();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("byte: " + b));
        }
        return b;
    }

    @Override
    public byte[] readBytes() throws IOException {
        byte[] bs = super.readBytes();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("bytes: " + new String(bs)));
        }
        return bs;
    }

    @Override
    public int readInt() throws IOException {
        int i = super.readInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("int: " + i));
        }
        return i;
    }

    @Override
    public long readLong() throws IOException {
        long l = super.readLong();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("long: " + l));
        }
        return l;
    }

    @Override
    public String readUTF() throws IOException {
        String string = super.readUTF();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("string: " + string));
        }
        return string;
    }

    @Override
    public String[] readUTFs() throws IOException {
        String[] strings = super.readUTFs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("list: " + strings));
        }
        return strings;
    }

    @Override
    public <T> T readEncodable(Class<T> encodableType) throws IOException {
        T object = super.readEncodable(encodableType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)">>> object");
        }
        return object;
    }

    @Override
    public <T> T[] readEncodables(Class<T> encodableType) throws IOException {
        T[] objects = super.readEncodables(encodableType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>> objects x" + objects.length));
        }
        return objects;
    }
}

