/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.io;

import java.io.IOException;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;

public class LazyInputStream
extends InputStream {
    private InputStreamProvider provider;
    private InputStream underlying = null;

    public LazyInputStream(InputStreamProvider provider) {
        Ensure.ensureThatArg(provider, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.provider = provider;
    }

    public void close() throws IOException {
        this.obtainUnderlyingIfRequired();
        this.underlying.close();
    }

    public int available() throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.available();
    }

    public void mark(int readlimit) {
        try {
            this.obtainUnderlyingIfRequired();
            this.underlying.mark(readlimit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean markSupported() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.markSupported();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int read() throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.read(b);
    }

    public long skip(long n) throws IOException {
        this.obtainUnderlyingIfRequired();
        return this.underlying.skip(n);
    }

    public void reset() throws IOException {
        this.obtainUnderlyingIfRequired();
        this.underlying.reset();
    }

    private void obtainUnderlyingIfRequired() throws IOException {
        if (this.underlying == null) {
            this.underlying = this.provider.getInputStream();
        }
    }

    public boolean equals(Object obj) {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.equals(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.hashCode();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            this.obtainUnderlyingIfRequired();
            return this.underlying.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface InputStreamProvider {
        public InputStream getInputStream() throws IOException;
    }
}

