/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.WrapperUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static Object[] getObjectAsObjectArray(Object option) {
        Class<?> arrayType = option.getClass().getComponentType();
        if (!arrayType.isPrimitive()) {
            return (Object[])option;
        }
        if (arrayType == Character.TYPE) {
            return ArrayUtils.convertCharToCharacterArray(option);
        }
        return ArrayUtils.convertPrimitiveToObjectArray(arrayType, option);
    }

    private static Object[] convertPrimitiveToObjectArray(Class<?> arrayType, Object originalArray) {
        Object[] convertedArray;
        try {
            Class<?> wrapperClass = WrapperUtils.wrap(arrayType);
            Constructor<?> constructor = wrapperClass.getConstructor(String.class);
            int len = Array.getLength(originalArray);
            convertedArray = (Object[])Array.newInstance(wrapperClass, len);
            for (int i = 0; i < len; ++i) {
                convertedArray[i] = constructor.newInstance(Array.get(originalArray, i).toString());
            }
        }
        catch (NoSuchMethodException e) {
            throw new NakedObjectException(e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NakedObjectException(e);
        }
        catch (IllegalArgumentException e) {
            throw new NakedObjectException(e);
        }
        catch (InstantiationException e) {
            throw new NakedObjectException(e);
        }
        catch (IllegalAccessException e) {
            throw new NakedObjectException(e);
        }
        catch (InvocationTargetException e) {
            throw new NakedObjectException(e);
        }
        return convertedArray;
    }

    private static Object[] convertCharToCharacterArray(Object originalArray) {
        char[] original = (char[])originalArray;
        int len = original.length;
        Object[] converted = new Character[len];
        for (int i = 0; i < converted.length; ++i) {
            converted[i] = new Character(original[i]);
        }
        return converted;
    }

    public static <T> T[] combine(T[] ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        T[][] arr$ = arrays;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            T[] array;
            for (T t : array = arr$[i$]) {
                list.add(t);
            }
        }
        return list.toArray(arrays[0]);
    }

    public static <T> List<T> asList(T[] items) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : items) {
            list.add(item);
        }
        return list;
    }

    public static <T> Set<T> asOrderedSet(T[] items) {
        LinkedHashSet<T> list = new LinkedHashSet<T>();
        if (items != null) {
            for (T item : items) {
                list.add(item);
            }
        }
        return list;
    }

    public static <T> List<T> concat(T[] elements, T ... elementsToAppend) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            result.add(element);
        }
        for (T element : elementsToAppend) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static String[] append(String[] args, String ... moreArgs) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(args));
        argList.addAll(Arrays.asList(moreArgs));
        return argList.toArray(new String[0]);
    }

    public static <T> List<T> concat(T[] elements, List<T> elementsToAppend) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            result.add(element);
        }
        for (T element : elementsToAppend) {
            if (element == null) continue;
            result.add(element);
        }
        return result;
    }

    public static <D, S> D[] copy(S[] source, Class<D> cls) {
        if (source == null) {
            throw new IllegalArgumentException("Source array cannot be null");
        }
        Object[] destination = (Object[])Array.newInstance(cls, source.length);
        System.arraycopy(source, 0, destination, 0, source.length);
        return destination;
    }

    private static <D, S> void copyFromInto(S[] source, D[] destination) {
        if (source == null) {
            throw new IllegalArgumentException("Source array cannot be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination array cannot be null");
        }
        if (source.length != destination.length) {
            throw new IllegalArgumentException("Source and destination arrays must be same length");
        }
        System.arraycopy(source, 0, destination, 0, source.length);
    }
}

