/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.lang;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IoUtils {
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    private IoUtils() {
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("OutputStream cannot be null");
        }
        byte[] buffer = new byte[1024];
        int count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void closeSafely(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeSafely(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

