/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.resource;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSource;
import org.nakedobjects.metamodel.commons.resource.ResourceStreamSourceAbstract;

public class ResourceStreamSourceComposite
extends ResourceStreamSourceAbstract {
    private static Logger LOG = Logger.getLogger(ResourceStreamSourceComposite.class);
    private List<ResourceStreamSource> resourceStreamSources = new ArrayList<ResourceStreamSource>();

    public ResourceStreamSourceComposite(ResourceStreamSource ... resourceStreamSources) {
        for (ResourceStreamSource rss : resourceStreamSources) {
            this.addResourceStreamSource(rss);
        }
    }

    public void addResourceStreamSource(ResourceStreamSource rss) {
        this.resourceStreamSources.add(rss);
    }

    protected InputStream doReadResource(String resourcePath) {
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            InputStream resourceStream = rss.readResource(resourcePath);
            if (resourceStream == null) continue;
            return resourceStream;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("could not load resource path '" + resourcePath + "' from " + this.getName()));
        }
        return null;
    }

    public OutputStream writeResource(String resourcePath) {
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            OutputStream os = rss.writeResource(resourcePath);
            if (os == null) continue;
            return os;
        }
        return null;
    }

    public String getName() {
        return "[" + this.resourceStreamNames() + "]";
    }

    private String resourceStreamNames() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (ResourceStreamSource rss : this.resourceStreamSources) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(rss.getName());
        }
        return buf.toString();
    }
}

