/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.consent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.applib.events.InteractionEvent;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionAdvisorFacet;
import org.nakedobjects.metamodel.consent.Veto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionResult {
    private final InteractionEvent interactionEvent;
    private final StringBuilder reasonBuf = new StringBuilder();
    private final List<InteractionAdvisorFacet> facets = new ArrayList<InteractionAdvisorFacet>();
    private State state = State.ADVISING;

    public InteractionResult(InteractionEvent interactionEvent) {
        this.interactionEvent = interactionEvent;
    }

    public InteractionEvent getInteractionEvent() {
        if (this.state == State.ADVISING) {
            this.interactionEvent.advised(this.getReason(), this.getAdvisorFacetClass());
            this.state = State.ADVISED;
        }
        return this.interactionEvent;
    }

    private Class<?> getAdvisorFacetClass() {
        InteractionAdvisorFacet advisorFacet = this.getAdvisorFacet();
        return advisorFacet != null ? advisorFacet.getClass() : null;
    }

    public void advise(String reason, InteractionAdvisorFacet facet) {
        if (this.state == State.ADVISED) {
            throw new IllegalStateException("Cannot append since have called getInteractionEvent");
        }
        if (reason == null) {
            return;
        }
        if (this.isVetoing()) {
            this.reasonBuf.append("; ");
        }
        this.facets.add(facet);
        this.reasonBuf.append(reason);
    }

    public boolean isVetoing() {
        return !this.isNotVetoing();
    }

    public boolean isNotVetoing() {
        return this.reasonBuf.length() == 0;
    }

    public InteractionAdvisorFacet getAdvisorFacet() {
        return this.facets.size() >= 1 ? this.facets.get(0) : null;
    }

    public List<InteractionAdvisorFacet> getAdvisorFacets() {
        return Collections.unmodifiableList(this.facets);
    }

    public Consent createConsent() {
        if (this.isNotVetoing()) {
            return new Allow(this);
        }
        return new Veto(this);
    }

    public String getReason() {
        return this.isNotVetoing() ? null : this.reasonBuf.toString();
    }

    public String toString() {
        return String.format("%s: %s: %s (%d facets advised)", new Object[]{this.interactionEvent, this.state, this.toStringInterpret(this.reasonBuf), this.facets.size()});
    }

    private String toStringInterpret(StringBuilder reasonBuf) {
        if (this.getReason().length() == 0) {
            return "allowed";
        }
        return "vetoed";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        ADVISING,
        ADVISED;

    }
}

