/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facetdecorator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetDecoratorSet
implements ApplicationScopedComponent {
    private final Map<Class<? extends Facet>, List<FacetDecorator>> facetDecoratorByFacetType = new HashMap<Class<? extends Facet>, List<FacetDecorator>>();
    private final Set<FacetDecorator> facetDecoratorSet = new LinkedHashSet<FacetDecorator>();

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    public void add(FacetDecorator decorator) {
        Class<? extends Facet>[] decoratedFacetTypes = decorator.getFacetTypes();
        for (int i = 0; i < decoratedFacetTypes.length; ++i) {
            Class<? extends Facet> decoratedFacetType = decoratedFacetTypes[i];
            this.getFacetDecoratorList(decoratedFacetType).add(decorator);
            this.facetDecoratorSet.add(decorator);
        }
    }

    private List<FacetDecorator> getFacetDecoratorList(Class<? extends Facet> decoratedFacetType) {
        List<FacetDecorator> facetDecoratorList = this.facetDecoratorByFacetType.get(decoratedFacetType);
        if (facetDecoratorList == null) {
            facetDecoratorList = new ArrayList<FacetDecorator>();
            this.facetDecoratorByFacetType.put(decoratedFacetType, facetDecoratorList);
        }
        return facetDecoratorList;
    }

    public void add(List<FacetDecorator> decorators) {
        for (FacetDecorator decorator : decorators) {
            this.add(decorator);
        }
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecoratorSet);
    }

    public boolean isEmpty() {
        return this.facetDecoratorByFacetType.isEmpty();
    }

    public void decorateAllFacets(FacetHolder holder) {
        if (this.isEmpty()) {
            return;
        }
        Class<? extends Facet>[] facetTypes = holder.getFacetTypes();
        for (int i = 0; i < facetTypes.length; ++i) {
            Facet facet = holder.getFacet(facetTypes[i]);
            this.decorateFacet(facet, holder);
        }
    }

    private void decorateFacet(Facet facet, FacetHolder requiredHolder) {
        Class<? extends Facet> facetType = facet.facetType();
        Class<? extends Facet> cls = facetType;
        List<FacetDecorator> decoratorList = this.facetDecoratorByFacetType.get(cls);
        if (decoratorList == null) {
            return;
        }
        for (FacetDecorator facetDecorator : decoratorList) {
            Facet decoratingFacet = facetDecorator.decorate(facet, requiredHolder);
            if (decoratingFacet == null) continue;
            this.ensureDecoratorMetContract(facetDecorator, decoratingFacet, facetType, requiredHolder);
        }
    }

    private void ensureDecoratorMetContract(FacetDecorator facetDecorator, Facet decoratingFacet, Class<? extends Facet> facetType, FacetHolder originalFacetHolder) {
        if (decoratingFacet.facetType() != facetType) {
            throw new ReflectionException(MessageFormat.format("Problem with facet decorator '{0}'; inconsistent decorating facetType() for {1}; was {2} but expectected facetType() of {3}", facetDecorator.getClass().getName(), decoratingFacet.getClass().getName(), decoratingFacet.facetType().getName(), facetType.getName()));
        }
        Facet facetForFacetType = originalFacetHolder.getFacet(decoratingFacet.facetType());
        if (facetForFacetType != decoratingFacet) {
            throw new ReflectionException(MessageFormat.format("Problem with facet decorator '{0}'; has not replaced original facet for facetType() of {1}", facetDecorator.getClass().getName(), facetType.getName()));
        }
    }

    public void debugData(DebugString str) {
        str.appendTitle("Facet decorators");
        str.indent();
        Set<Class<? extends Facet>> facetTypes = this.facetDecoratorByFacetType.keySet();
        if (facetTypes.size() == 0) {
            str.append("none");
        } else {
            for (Class<? extends Facet> cls : facetTypes) {
                str.appendln(cls.getName(), this.facetDecoratorByFacetType.get(cls));
            }
        }
        str.unindent();
    }
}

