/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.memberorder;

import java.util.Comparator;
import java.util.StringTokenizer;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.facets.ordering.OrderSetGroupNameComparator;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberIdentifierComparator;
import org.nakedobjects.metamodel.facets.ordering.memberorder.MemberOrderFacet;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;

public class MemberOrderComparator
implements Comparator {
    private final boolean ensureInSameGroup;
    private final Comparator fallbackComparator = new MemberIdentifierComparator();
    private final OrderSetGroupNameComparator orderSetComparator = new OrderSetGroupNameComparator(true);

    public MemberOrderComparator(boolean ensureGroupIsSame) {
        this.ensureInSameGroup = ensureGroupIsSame;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof NakedObjectMemberPeer && o2 instanceof NakedObjectMemberPeer) {
            return this.compare((NakedObjectMemberPeer)o1, (NakedObjectMemberPeer)o2);
        }
        if (o1 instanceof OrderSet && o2 instanceof OrderSet) {
            return this.orderSetComparator.compare(o1, o2);
        }
        if (o1 instanceof NakedObjectMemberPeer && o2 instanceof OrderSet) {
            return -1;
        }
        if (o1 instanceof OrderSet && o2 instanceof NakedObjectMemberPeer) {
            return 1;
        }
        throw new IllegalArgumentException("can only compare MemberPeers and OrderSets");
    }

    public int compare(NakedObjectMemberPeer o1, NakedObjectMemberPeer o2) {
        MemberOrderFacet m1 = this.getMemberOrder(o1);
        MemberOrderFacet m2 = this.getMemberOrder(o2);
        if (m1 == null && m2 == null) {
            return this.fallbackComparator.compare(o1, o2);
        }
        if (m1 == null && m2 != null) {
            return 1;
        }
        if (m1 != null && m2 == null) {
            return -1;
        }
        if (this.ensureInSameGroup && !m1.name().equals(m2.name())) {
            throw new IllegalArgumentException("Not in same group");
        }
        StringTokenizer tokens1 = new StringTokenizer(m1.sequence(), ".", false);
        String[] components1 = new String[tokens1.countTokens()];
        int i = 0;
        while (tokens1.hasMoreTokens()) {
            components1[i] = tokens1.nextToken();
            ++i;
        }
        StringTokenizer tokens2 = new StringTokenizer(m2.sequence(), ".", false);
        String[] components2 = new String[tokens2.countTokens()];
        int i2 = 0;
        while (tokens2.hasMoreTokens()) {
            components2[i2] = tokens2.nextToken();
            ++i2;
        }
        int length1 = components1.length;
        int length2 = components2.length;
        if (length1 == 0 && length2 == 0) {
            return this.fallbackComparator.compare(o1, o2);
        }
        int n = 0;
        int length;
        while (length1 >= (length = n + 1) || length2 < length) {
            if (length2 < length && length1 >= length) {
                return 1;
            }
            if (length1 < length && length2 < length) {
                return this.fallbackComparator.compare(o1, o2);
            }
            int componentCompare = 0;
            try {
                Integer c1 = Integer.valueOf(components1[n]);
                Integer c2 = Integer.valueOf(components2[n]);
                componentCompare = c1.compareTo(c2);
            }
            catch (NumberFormatException nfe) {
                componentCompare = components1[n].compareTo(components2[n]);
            }
            if (componentCompare != 0) {
                return componentCompare;
            }
            ++n;
        }
        return -1;
    }

    private MemberOrderFacet getMemberOrder(FacetHolder facetHolder) {
        return facetHolder.getFacet(MemberOrderFacet.class);
    }
}

