/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.properties.choices;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacetAbstract;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.NakedObjectAdapterUtils;
import org.nakedobjects.metamodel.util.NakedObjectInvokeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyChoicesFacetViaMethod
extends PropertyChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesClass;
    private final SpecificationLoader specificationLoader;
    private final RuntimeContext runtimeContext;

    public PropertyChoicesFacetViaMethod(Method method, Class<?> choicesClass, FacetHolder holder, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(holder);
        this.method = method;
        this.choicesClass = choicesClass;
        this.specificationLoader = specificationLoader;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public boolean impliesResolve() {
        return true;
    }

    @Override
    public boolean impliesObjectChanged() {
        return false;
    }

    @Override
    public Object[] getChoices(NakedObject owningAdapter) {
        Object options = NakedObjectInvokeUtils.invoke(this.method, owningAdapter);
        if (options == null) {
            return null;
        }
        if (options.getClass().isArray()) {
            return ArrayUtils.getObjectAsObjectArray(options);
        }
        NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(this.choicesClass);
        return NakedObjectAdapterUtils.getCollectionAsObjectArray(options, specification, this.getRuntimeContext());
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",class=" + this.choicesClass;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }
}

