/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.regex;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.RegEx;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.RegExFacetAnnotation;
import org.nakedobjects.metamodel.facets.propparam.validate.regex.TitleFacetFormattedByRegex;
import org.nakedobjects.metamodel.java5.AnnotationBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExAnnotationFacetFactory
extends AnnotationBasedFacetFactoryAbstract {
    public RegExAnnotationFacetFactory() {
        super(NakedObjectFeatureType.OBJECTS_PROPERTIES_AND_PARAMETERS);
    }

    @Override
    public boolean process(Class<?> cls, MethodRemover methodRemover, FacetHolder holder) {
        RegEx annotation = this.getAnnotation(cls, RegEx.class);
        return FacetUtil.addFacet(this.createRegexFacet(annotation, holder));
    }

    @Override
    public boolean process(Method method, MethodRemover methodRemover, FacetHolder holder) {
        Class<?> returnType = method.getReturnType();
        if (!this.isString(returnType)) {
            return false;
        }
        RegEx annotation = this.getAnnotation(method, RegEx.class);
        return this.addRegexFacetAndCorrespondingTitleFacet(holder, annotation);
    }

    @Override
    public boolean processParams(Method method, int paramNum, FacetHolder holder) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (paramNum >= parameterTypes.length) {
            return false;
        }
        if (!this.isString(parameterTypes[paramNum])) {
            return false;
        }
        Annotation[] parameterAnnotations = this.getParameterAnnotations(method)[paramNum];
        for (int j = 0; j < parameterAnnotations.length; ++j) {
            if (!(parameterAnnotations[j] instanceof RegEx)) continue;
            RegEx annotation = (RegEx)parameterAnnotations[j];
            return this.addRegexFacetAndCorrespondingTitleFacet(holder, annotation);
        }
        return false;
    }

    private boolean addRegexFacetAndCorrespondingTitleFacet(FacetHolder holder, RegEx annotation) {
        RegExFacet regexFacet = this.createRegexFacet(annotation, holder);
        if (regexFacet == null) {
            return false;
        }
        FacetUtil.addFacet(regexFacet);
        TitleFacet titleFacet = this.createTitleFacet(regexFacet);
        return FacetUtil.addFacet(titleFacet);
    }

    private RegExFacet createRegexFacet(RegEx annotation, FacetHolder holder) {
        if (annotation == null) {
            return null;
        }
        String validationExpression = annotation.validation();
        boolean caseSensitive = annotation.caseSensitive();
        String formatExpression = annotation.format();
        return new RegExFacetAnnotation(validationExpression, formatExpression, caseSensitive, holder);
    }

    private TitleFacet createTitleFacet(RegExFacet regexFacet) {
        return new TitleFacetFormattedByRegex(regexFacet);
    }
}

