/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.java5;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.When;
import org.nakedobjects.metamodel.facets.FacetFactoryAbstract;
import org.nakedobjects.metamodel.java5.AnnotationBasedFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationBasedFacetFactoryAbstract
extends FacetFactoryAbstract
implements AnnotationBasedFacetFactory {
    public AnnotationBasedFacetFactoryAbstract(NakedObjectFeatureType[] featureTypes) {
        super(featureTypes);
    }

    public boolean recognizes(Method method) {
        return false;
    }

    protected boolean isString(Class<?> cls) {
        return cls.equals(String.class);
    }

    protected org.nakedobjects.metamodel.facets.When decodeWhen(When when) {
        if (when == When.ALWAYS) {
            return org.nakedobjects.metamodel.facets.When.ALWAYS;
        }
        if (when == When.ONCE_PERSISTED) {
            return org.nakedobjects.metamodel.facets.When.ONCE_PERSISTED;
        }
        if (when == When.UNTIL_PERSISTED) {
            return org.nakedobjects.metamodel.facets.When.UNTIL_PERSISTED;
        }
        return org.nakedobjects.metamodel.facets.When.NEVER;
    }

    protected <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (cls == null) {
            return null;
        }
        T annotation = cls.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> superclass = cls.getSuperclass();
        if (superclass != null) {
            try {
                T annotationFromSuperclass = this.getAnnotation(superclass, annotationClass);
                if (annotationFromSuperclass != null) {
                    return annotationFromSuperclass;
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = cls.getInterfaces()) {
            T annotationFromInterface = this.getAnnotation(iface, annotationClass);
            if (annotationFromInterface == null) continue;
            return annotationFromInterface;
        }
        return null;
    }

    protected <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return null;
        }
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return this.getAnnotation(parentClassMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return this.getAnnotation(ifaceMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean isAnnotationPresent(Method method, Class<? extends Annotation> annotationClass) {
        Class<?>[] interfaces;
        if (method == null) {
            return false;
        }
        boolean present = method.isAnnotationPresent(annotationClass);
        if (present) {
            return true;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return this.isAnnotationPresent(parentClassMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return this.isAnnotationPresent(ifaceMethod, annotationClass);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return false;
    }

    protected Annotation[][] getParameterAnnotations(Method method) {
        Class<?>[] interfaces;
        if (method == null) {
            return this.noParamAnnotationsFor(method);
        }
        Annotation[][] allParamAnnotations = method.getParameterAnnotations();
        boolean foundAnnotationsForAnyParameter = false;
        for (Annotation[] singleParamAnnotations : allParamAnnotations) {
            if (singleParamAnnotations.length <= 0) continue;
            foundAnnotationsForAnyParameter = true;
            break;
        }
        if (foundAnnotationsForAnyParameter) {
            return allParamAnnotations;
        }
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        Class<?> superclass = methodDeclaringClass.getSuperclass();
        if (superclass != null) {
            try {
                Method parentClassMethod = superclass.getMethod(method.getName(), method.getParameterTypes());
                return this.getParameterAnnotations(parentClassMethod);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (Class<?> iface : interfaces = methodDeclaringClass.getInterfaces()) {
            try {
                Method ifaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                return this.getParameterAnnotations(ifaceMethod);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return this.noParamAnnotationsFor(method);
    }

    private Annotation[][] noParamAnnotationsFor(Method method) {
        return new Annotation[method.getParameterTypes().length][0];
    }
}

