/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.java5;

import java.lang.reflect.Method;
import java.util.List;
import org.nakedobjects.metamodel.commons.filters.AbstractFilter;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.facets.DecoratingFacet;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;

public final class ImperativeFacetUtils {
    private ImperativeFacetUtils() {
    }

    public static ImperativeFacet getImperativeFacet(Facet facet) {
        if (facet instanceof ImperativeFacet) {
            return (ImperativeFacet)((Object)facet);
        }
        if (facet instanceof DecoratingFacet) {
            DecoratingFacet decoratingFacet = (DecoratingFacet)CastUtils.cast(facet);
            return ImperativeFacetUtils.getImperativeFacet(decoratingFacet.getDecoratedFacet());
        }
        return null;
    }

    public static boolean isImperativeFacet(Facet facet) {
        return ImperativeFacetUtils.getImperativeFacet(facet) != null;
    }

    public static ImperativeFacetFlags getImperativeFacetFlags(NakedObjectMember member, Method method) {
        Facet[] allFacets;
        ImperativeFacetFlags flags = new ImperativeFacetFlags();
        if (member == null) {
            return flags;
        }
        for (Facet facet : allFacets = member.getFacets(AbstractFilter.noop(Facet.class))) {
            List<Method> methods;
            ImperativeFacet imperativeFacet = ImperativeFacetUtils.getImperativeFacet(facet);
            if (imperativeFacet == null || !(methods = imperativeFacet.getMethods()).contains(method)) continue;
            flags.apply(imperativeFacet);
            if (flags.bothSet()) break;
        }
        return flags;
    }

    public static class ImperativeFacetFlags {
        private boolean impliesResolve;
        private boolean impliesObjectChanged;

        public void apply(ImperativeFacet imperativeFacet) {
            this.impliesResolve |= imperativeFacet.impliesResolve();
            this.impliesObjectChanged |= imperativeFacet.impliesObjectChanged();
        }

        public boolean bothSet() {
            return this.impliesResolve && this.impliesObjectChanged;
        }

        public boolean impliesResolve() {
            return this.impliesResolve;
        }

        public boolean impliesObjectChanged() {
            return this.impliesObjectChanged;
        }
    }
}

