/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.spec;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.commons.filters.AbstractFilter;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorSet;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetInferred;
import org.nakedobjects.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.dirty.ClearDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.dirty.IsDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.dirty.MarkDirtyObjectFacet;
import org.nakedobjects.metamodel.facets.object.ident.icon.IconFacet;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacet;
import org.nakedobjects.metamodel.facets.object.ident.plural.PluralFacetInferred;
import org.nakedobjects.metamodel.facets.object.ident.title.TitleFacet;
import org.nakedobjects.metamodel.facets.object.notpersistable.InitiatedBy;
import org.nakedobjects.metamodel.facets.object.notpersistable.NotPersistableFacet;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.java5.ImperativeFacetUtils;
import org.nakedobjects.metamodel.runtimecontext.ObjectInstantiationException;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.spec.IntrospectableSpecificationAbstract;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectActionSet;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectAssociationAbstract;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecificationException;
import org.nakedobjects.metamodel.spec.Persistability;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectMember;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorAbstract;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.specloader.internal.OneToManyAssociationImpl;
import org.nakedobjects.metamodel.specloader.internal.OneToOneAssociationImpl;
import org.nakedobjects.metamodel.specloader.internal.introspector.JavaIntrospector;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectAssociationPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectAssociationPeer;
import org.nakedobjects.metamodel.util.CallbackUtils;
import org.nakedobjects.metamodel.util.SpecUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSpecification
extends IntrospectableSpecificationAbstract
implements DebugInfo,
FacetHolder {
    private static final Logger LOG = Logger.getLogger(JavaSpecification.class);
    private final SubclassList subclasses;
    private final NakedObjectReflectorAbstract reflector;
    private JavaIntrospector introspector;
    private Persistability persistable;
    private String pluralName;
    private String shortName;
    private String singularName;
    private String description;
    private NakedObjectSpecification[] interfaces;
    private IconFacet iconMethod;
    private MarkDirtyObjectFacet markDirtyObjectFacet;
    private ClearDirtyObjectFacet clearDirtyObjectFacet;
    private IsDirtyObjectFacet isDirtyObjectFacet;
    private Hashtable<Method, NakedObjectMember> membersByMethod = null;
    private Class<?> cls;
    private boolean whetherAbstract;
    private boolean whetherFinal;
    private boolean service;
    private TitleFacet titleFacet;

    public JavaSpecification(Class<?> cls, NakedObjectReflectorAbstract reflector, RuntimeContext runtimeContext) {
        super(runtimeContext);
        this.introspector = new JavaIntrospector(cls, this, reflector);
        this.subclasses = new SubclassList();
        this.identifier = Identifier.classIdentifier(cls);
        this.reflector = reflector;
    }

    @Override
    public void addSubclass(NakedObjectSpecification subclass) {
        this.subclasses.addSubclass(subclass);
    }

    @Override
    public boolean hasSubclasses() {
        return this.subclasses.hasSubclasses();
    }

    @Override
    public NakedObjectSpecification[] interfaces() {
        return this.interfaces;
    }

    @Override
    public NakedObjectSpecification[] subclasses() {
        return this.subclasses.toArray();
    }

    @Override
    public boolean isOfType(NakedObjectSpecification specification) {
        if (specification == this) {
            return true;
        }
        if (this.interfaces != null) {
            int len = this.interfaces.length;
            for (int i = 0; i < len; ++i) {
                if (!this.interfaces[i].isOfType(specification)) continue;
                return true;
            }
        }
        if (this.superClassSpecification != null) {
            return this.superClassSpecification.isOfType(specification);
        }
        return false;
    }

    @Override
    public synchronized void introspect(FacetDecoratorSet decorator) {
        PluralFacet pluralFacet;
        boolean skipIntrospection;
        if (this.introspector == null) {
            throw new ReflectionException("Introspection already taken place, cannot introspect again");
        }
        this.cls = this.introspector.getIntrospectedClass();
        boolean bl = skipIntrospection = JavaClassUtils.isJavaClass(this.cls) || this.isValueClass(this.cls);
        if (skipIntrospection && LOG.isDebugEnabled()) {
            LOG.debug((Object)("skipping introspection of properties and actions for " + this.cls.getName() + " (java.xxx class)"));
        }
        this.introspector.introspectClass();
        this.fullName = this.introspector.getFullName();
        this.shortName = this.introspector.shortName();
        NamedFacet namedFacet = this.getFacet(NamedFacet.class);
        if (namedFacet == null) {
            namedFacet = new NamedFacetInferred(NameConvertorUtils.naturalName(this.shortName), this);
            this.addFacet(namedFacet);
        }
        if ((pluralFacet = this.getFacet(PluralFacet.class)) == null) {
            pluralFacet = new PluralFacetInferred(NameConvertorUtils.pluralName(namedFacet.value()), this);
            this.addFacet(pluralFacet);
        }
        this.whetherAbstract = this.introspector.isAbstract();
        this.whetherFinal = this.introspector.isFinal();
        String superclassName = this.introspector.getSuperclass();
        String[] interfaceNames = this.introspector.getInterfaces();
        if (skipIntrospection) {
            this.fields = new NakedObjectAssociation[0];
            this.objectActions = new NakedObjectAction[0];
            this.interfaces = new NakedObjectSpecification[0];
        } else {
            NakedObjectReflectorAbstract loader = this.getReflector();
            if (superclassName != null) {
                this.superClassSpecification = loader.loadSpecification(superclassName);
                if (this.superClassSpecification != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("  Superclass " + superclassName));
                    }
                    this.superClassSpecification.addSubclass(this);
                }
            }
            ArrayList<NakedObjectSpecification> interfaceSpecList = new ArrayList<NakedObjectSpecification>();
            for (int i = 0; i < interfaceNames.length; ++i) {
                Class<?> substitutedInterfaceClass = this.getSubstitutedClass(interfaceNames[i], this.getClassSubstitutor());
                if (substitutedInterfaceClass == null) continue;
                NakedObjectSpecification interfacespec = loader.loadSpecification(substitutedInterfaceClass.getName());
                interfaceSpecList.add(interfacespec);
                interfacespec.addSubclass(this);
            }
            this.interfaces = interfaceSpecList.toArray(new NakedObjectSpecification[0]);
            this.introspector.introspectPropertiesAndCollections();
            OrderSet orderedFields = this.introspector.getFields();
            if (orderedFields != null) {
                this.fields = this.orderFields(orderedFields);
            }
            this.introspector.introspectActions();
            OrderSet orderedActions = this.introspector.getClassActions();
            orderedActions = this.introspector.getObjectActions();
            this.objectActions = this.orderActions(orderedActions);
        }
        this.decorateAllFacets(decorator);
        this.clearDirtyObjectFacet = this.getFacet(ClearDirtyObjectFacet.class);
        this.markDirtyObjectFacet = this.getFacet(MarkDirtyObjectFacet.class);
        this.isDirtyObjectFacet = this.getFacet(IsDirtyObjectFacet.class);
        namedFacet = this.getFacet(NamedFacet.class);
        this.singularName = namedFacet.value();
        pluralFacet = this.getFacet(PluralFacet.class);
        this.pluralName = pluralFacet.value();
        DescribedAsFacet describedAsFacet = this.getFacet(DescribedAsFacet.class);
        this.description = describedAsFacet.value();
        this.iconMethod = this.getFacet(IconFacet.class);
        NotPersistableFacet notPersistableFacet = this.getFacet(NotPersistableFacet.class);
        InitiatedBy initiatedBy = notPersistableFacet.value();
        this.persistable = initiatedBy == InitiatedBy.USER_OR_PROGRAM ? Persistability.TRANSIENT : (initiatedBy == InitiatedBy.USER ? Persistability.PROGRAM_PERSISTABLE : Persistability.USER_PERSISTABLE);
        this.introspector = null;
    }

    private boolean isValueClass(Class<?> type) {
        return type.getName().startsWith("org.nakedobjects.applib.value.");
    }

    private Class<?> getSubstitutedClass(String fullyQualifiedClassName, ClassSubstitutor classSubstitor) {
        Class<?> interfaceClass;
        try {
            interfaceClass = Class.forName(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return classSubstitor.getClass(interfaceClass);
    }

    @Override
    public boolean isIntrospected() {
        return this.introspector == null;
    }

    private void decorateAllFacets(FacetDecoratorSet decoratorSet) {
        int i;
        decoratorSet.decorateAllFacets(this);
        for (i = 0; i < this.fields.length; ++i) {
            NakedObjectAssociation nakedObjectAssociation = this.fields[i];
            decoratorSet.decorateAllFacets(nakedObjectAssociation);
        }
        for (i = 0; i < this.objectActions.length; ++i) {
            NakedObjectAction nakedObjectAction = this.objectActions[i];
            decoratorSet.decorateAllFacets(nakedObjectAction);
            NakedObjectActionParameter[] parameters = this.objectActions[i].getParameters();
            for (int j = 0; j < parameters.length; ++j) {
                decoratorSet.decorateAllFacets(parameters[j]);
            }
        }
    }

    public NakedObjectMember getMember(Method method) {
        if (this.membersByMethod == null) {
            this.membersByMethod = new Hashtable();
            this.cataloguePropertiesAndCollections(this.membersByMethod);
            this.catalogueActions(this.membersByMethod);
        }
        return this.membersByMethod.get(method);
    }

    private void cataloguePropertiesAndCollections(Hashtable<Method, NakedObjectMember> membersByMethod) {
        Filter<NakedObjectAssociation> noop = AbstractFilter.noop(NakedObjectAssociation.class);
        NakedObjectAssociation[] fields = this.getAssociations(noop);
        for (int i = 0; i < fields.length; ++i) {
            NakedObjectAssociation field = fields[i];
            Facet[] facets = field.getFacets(ImperativeFacet.FILTER);
            for (int j = 0; j < facets.length; ++j) {
                ImperativeFacet facet = ImperativeFacetUtils.getImperativeFacet(facets[j]);
                for (Method imperativeFacetMethod : facet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, field);
                }
            }
        }
    }

    private void catalogueActions(Hashtable<Method, NakedObjectMember> membersByMethod) {
        NakedObjectAction[] userActions = this.getObjectActions(NakedObjectActionConstants.USER);
        for (int i = 0; i < userActions.length; ++i) {
            NakedObjectAction userAction = userActions[i];
            Facet[] facets = userAction.getFacets(ImperativeFacet.FILTER);
            for (int j = 0; j < facets.length; ++j) {
                ImperativeFacet facet = ImperativeFacetUtils.getImperativeFacet(facets[j]);
                for (Method imperativeFacetMethod : facet.getMethods()) {
                    membersByMethod.put(imperativeFacetMethod, userAction);
                }
            }
        }
    }

    @Override
    public NakedObjectAssociation getAssociation(String id) {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getId().equals(id)) continue;
            return this.fields[i];
        }
        throw new NakedObjectSpecificationException("No field called '" + id + "' in '" + this.getSingularName() + "'");
    }

    @Override
    public NakedObjectAction getObjectAction(NakedObjectActionType type, String id, NakedObjectSpecification[] parameters) {
        NakedObjectAction[] availableActions = ArrayUtils.combine(this.objectActions, this.getServiceActions(type));
        return this.getAction(availableActions, type, id, parameters);
    }

    @Override
    public NakedObjectAction getObjectAction(NakedObjectActionType type, String nameParmsIdentityString) {
        NakedObjectAction[] availableActions = ArrayUtils.combine(this.objectActions, this.getServiceActions(type));
        return this.getAction2(availableActions, type, nameParmsIdentityString);
    }

    private NakedObjectAction getAction(NakedObjectAction[] availableActions, NakedObjectActionType type, String actionName, NakedObjectSpecification[] parameters) {
        block0: for (int i = 0; i < availableActions.length; ++i) {
            NakedObjectAction action = availableActions[i];
            if (action.getActions().length > 0) {
                NakedObjectAction a = this.getAction(action.getActions(), type, actionName, parameters);
                if (a == null) continue;
                return a;
            }
            if (!action.getType().equals((Object)type) || actionName != null && !actionName.equals(action.getId()) || action.getParameters().length != parameters.length) continue;
            for (int j = 0; j < parameters.length; ++j) {
                if (!parameters[j].isOfType(action.getParameters()[j].getSpecification())) continue block0;
            }
            return action;
        }
        return null;
    }

    private NakedObjectAction getAction2(NakedObjectAction[] availableActions, NakedObjectActionType type, String nameParmsIdentityString) {
        if (nameParmsIdentityString == null) {
            return null;
        }
        for (int i = 0; i < availableActions.length; ++i) {
            NakedObjectAction action = availableActions[i];
            if (action.getActions().length > 0) {
                NakedObjectAction a = this.getAction2(action.getActions(), type, nameParmsIdentityString);
                if (a == null) continue;
                return a;
            }
            if (!this.sameActionTypeOrNotSpecified(type, action) || !nameParmsIdentityString.equals(action.getIdentifier().toNameParmsIdentityString())) continue;
            return action;
        }
        return null;
    }

    @Override
    protected NakedObjectAction[] getActions(NakedObjectAction[] availableActions, NakedObjectActionType type) {
        ArrayList<NakedObjectAction> actions = new ArrayList<NakedObjectAction>();
        block0: for (NakedObjectAction action : availableActions) {
            NakedObjectActionType actionType = action.getType();
            if (actionType == NakedObjectActionConstants.SET) {
                NakedObjectAction[] subActions;
                NakedObjectActionSet actionSet = (NakedObjectActionSet)action;
                for (NakedObjectAction subAction : subActions = actionSet.getActions()) {
                    if (!this.sameActionTypeOrNotSpecified(type, subAction)) continue;
                    actions.add(subAction);
                    continue block0;
                }
                continue;
            }
            if (!this.sameActionTypeOrNotSpecified(type, action)) continue;
            actions.add(action);
        }
        return actions.toArray(new NakedObjectAction[0]);
    }

    private boolean sameActionTypeOrNotSpecified(NakedObjectActionType type, NakedObjectAction action) {
        return type == null || action.getType().equals((Object)type);
    }

    private NakedObjectAssociation[] orderFields(OrderSet order) {
        NakedObjectAssociation[] fields = new NakedObjectAssociation[order.size()];
        Enumeration<NakedObjectAssociation> elements = CastUtils.enumerationOver(order.elements(), NakedObjectAssociation.class);
        int actionCnt = 0;
        while (elements.hasMoreElements()) {
            NakedObjectAssociation element = elements.nextElement();
            if (element instanceof JavaNakedObjectAssociationPeer) {
                JavaNakedObjectAssociationPeer javaNakedObjectAssociationPeer = (JavaNakedObjectAssociationPeer)((Object)element);
                NakedObjectAssociation nakedObjectAssociation = this.createNakedObjectField(javaNakedObjectAssociationPeer);
                fields[actionCnt++] = nakedObjectAssociation;
                continue;
            }
            if (element instanceof OrderSet) continue;
            throw new UnknownTypeException(element);
        }
        if (actionCnt < fields.length) {
            NakedObjectAssociation[] actualActions = new NakedObjectAssociation[actionCnt];
            System.arraycopy(fields, 0, actualActions, 0, actionCnt);
            return actualActions;
        }
        return fields;
    }

    private NakedObjectAction[] orderActions(OrderSet order) {
        NakedObjectAction[] actions = new NakedObjectAction[order.size()];
        Enumeration<NakedObjectAction> elements = CastUtils.enumerationOver(order.elements(), NakedObjectAction.class);
        int actionCnt = 0;
        while (elements.hasMoreElements()) {
            NakedObjectAction element = elements.nextElement();
            if (element instanceof JavaNakedObjectActionPeer) {
                JavaNakedObjectActionPeer javaNakedObjectActionPeer = (JavaNakedObjectActionPeer)((Object)element);
                String actionId = javaNakedObjectActionPeer.getIdentifier().getMemberName();
                NakedObjectActionImpl nakedObjectAction = new NakedObjectActionImpl(actionId, javaNakedObjectActionPeer, this.getRuntimeContext());
                actions[actionCnt++] = nakedObjectAction;
                continue;
            }
            if (element instanceof OrderSet) {
                OrderSet set = (OrderSet)((Object)element);
                actions[actionCnt++] = new NakedObjectActionSet("", set.getGroupFullName(), this.orderActions(set), this.getRuntimeContext());
                continue;
            }
            throw new UnknownTypeException(element);
        }
        if (actionCnt < actions.length) {
            NakedObjectAction[] actualActions = new NakedObjectAction[actionCnt];
            System.arraycopy(actions, 0, actualActions, 0, actionCnt);
            return actualActions;
        }
        return actions;
    }

    private NakedObjectAssociation createNakedObjectField(NakedObjectAssociationPeer peer) {
        NakedObjectAssociationAbstract field;
        if (peer.isOneToOne()) {
            field = new OneToOneAssociationImpl(peer, this.getRuntimeContext());
        } else if (peer.isOneToMany()) {
            field = new OneToManyAssociationImpl(peer, this.getRuntimeContext());
        } else {
            throw new NakedObjectException();
        }
        return field;
    }

    @Override
    public boolean isCollectionOrIsAggregated() {
        return this.isCollection() || this.isValueOrIsAggregated();
    }

    @Override
    public boolean isAbstract() {
        return this.whetherAbstract;
    }

    @Override
    public boolean isFinal() {
        return this.whetherFinal;
    }

    @Override
    public boolean isService() {
        return this.service;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getSingularName() {
        return this.singularName;
    }

    @Override
    public String getPluralName() {
        return this.pluralName;
    }

    @Override
    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    @Override
    public String getTitle(NakedObject object) {
        String titleString;
        if (this.titleFacet == null) {
            this.titleFacet = this.getFacet(TitleFacet.class);
        }
        if (this.titleFacet != null && (titleString = this.titleFacet.title(object)) != null && !titleString.equals("")) {
            return titleString;
        }
        return (this.isService() ? "" : "Untitled ") + this.getSingularName();
    }

    @Override
    public String getIconName(NakedObject reference) {
        if (this.iconMethod == null) {
            return null;
        }
        return this.iconMethod.iconName(reference);
    }

    @Override
    public Persistability persistability() {
        return this.persistable;
    }

    @Override
    public Object createObject(NakedObjectSpecification.CreationMode creationMode) {
        if (this.cls.isArray()) {
            return Array.newInstance(this.cls.getComponentType(), 0);
        }
        try {
            Object object = this.getRuntimeContext().instantiate(this.cls);
            if (creationMode == NakedObjectSpecification.CreationMode.INITIALIZE) {
                NakedObject adapter = this.getRuntimeContext().adapterFor(object);
                NakedObjectAssociation[] fields = adapter.getSpecification().getAssociations();
                for (int i = 0; i < fields.length; ++i) {
                    fields[i].toDefault(adapter);
                }
                this.getRuntimeContext().injectDependenciesInto(object);
                CallbackUtils.callCallback(adapter, CreatedCallbackFacet.class);
            }
            return object;
        }
        catch (ObjectInstantiationException e) {
            throw new NakedObjectException("Failed to create instance of type " + this.cls.getName(), e);
        }
    }

    @Override
    public boolean isDirty(NakedObject object) {
        return this.isDirtyObjectFacet == null ? false : this.isDirtyObjectFacet.invoke(object);
    }

    @Override
    public void clearDirty(NakedObject object) {
        if (this.clearDirtyObjectFacet != null) {
            this.clearDirtyObjectFacet.invoke(object);
        }
    }

    @Override
    public void markDirty(NakedObject object) {
        if (this.markDirtyObjectFacet != null) {
            this.markDirtyObjectFacet.invoke(object);
        }
    }

    @Override
    public void markAsService() {
        NakedObjectAssociation[] fields = this.getAssociations();
        if (fields != null && fields.length > 0) {
            String fieldNames = "";
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getId();
                if ("id".indexOf(name) != -1) continue;
                fieldNames = fieldNames + (fieldNames.length() > 0 ? ", " : "") + name;
            }
            if (fieldNames.length() > 0) {
                throw new NakedObjectSpecificationException("Service object " + this.getFullName() + " should have no fields, but has: " + fieldNames);
            }
        }
        this.service = true;
    }

    @Override
    public void debugData(DebugString debug) {
        debug.blankLine();
        debug.appendln("Title", this.getFacet(TitleFacet.class));
        if (this.iconMethod != null) {
            debug.appendln("Icon", this.iconMethod);
        }
        debug.unindent();
    }

    @Override
    public String debugTitle() {
        return "NO Member Specification";
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append("class", this.fullName);
        str.append("type", SpecUtils.typeNameFor(this));
        str.append("persistable", (Object)this.persistable);
        str.append("superclass", this.superClassSpecification == null ? "Object" : this.superClassSpecification.getFullName());
        return str.toString();
    }

    private NakedObjectReflectorAbstract getReflector() {
        return this.reflector;
    }

    private ClassSubstitutor getClassSubstitutor() {
        return this.reflector.getClassSubstitutor();
    }

    private class SubclassList {
        private final List<NakedObjectSpecification> classes = new ArrayList<NakedObjectSpecification>();

        private SubclassList() {
        }

        public void addSubclass(NakedObjectSpecification subclass) {
            this.classes.add(subclass);
        }

        public boolean hasSubclasses() {
            return !this.classes.isEmpty();
        }

        public NakedObjectSpecification[] toArray() {
            return this.classes.toArray(new NakedObjectSpecification[0]);
        }
    }
}

