/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.spec.feature;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.filters.AbstractFilter;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectAssociationFilters {
    public static final Filter<NakedObjectAssociation> PROPERTIES = new AbstractFilter<NakedObjectAssociation>(){

        @Override
        public boolean accept(NakedObjectAssociation property) {
            return property.isOneToOneAssociation();
        }
    };
    public static final Filter<NakedObjectAssociation> ALL = new AbstractFilter<NakedObjectAssociation>(){

        @Override
        public boolean accept(NakedObjectAssociation property) {
            return true;
        }
    };
    public static final Filter<NakedObjectAssociation> COLLECTIONS = new AbstractFilter<NakedObjectAssociation>(){

        @Override
        public boolean accept(NakedObjectAssociation property) {
            return property.isOneToManyAssociation();
        }
    };
    public static final Filter<NakedObjectAssociation> STATICALLY_VISIBLE_ASSOCIATIONS = new AbstractFilter<NakedObjectAssociation>(){

        @Override
        public boolean accept(NakedObjectAssociation property) {
            return !property.containsFacet(HiddenFacet.class);
        }
    };

    private NakedObjectAssociationFilters() {
    }

    public static Filter<NakedObjectAssociation> dynamicallyVisible(final AuthenticationSession session, final NakedObject target) {
        return new AbstractFilter<NakedObjectAssociation>(){

            @Override
            public boolean accept(NakedObjectAssociation nakedObjectAssociation) {
                Consent visible = nakedObjectAssociation.isVisible(session, target);
                return visible.isAllowed();
            }
        };
    }
}

