/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorSet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.nakedobjects.metamodel.spec.IntrospectableSpecification;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.metamodel.specloader.SpecificationLoaderAware;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.internal.cache.SimpleSpecificationCache;
import org.nakedobjects.metamodel.specloader.internal.cache.SpecificationCache;
import org.nakedobjects.metamodel.specloader.internal.facetprocessor.FacetProcessor;
import org.nakedobjects.metamodel.specloader.internal.instances.InstanceCollectionSpecification;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;
import org.nakedobjects.metamodel.specloader.traverser.SpecificationTraverser;
import org.nakedobjects.metamodel.specloader.validator.MetaModelValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectReflectorAbstract
implements NakedObjectReflector,
DebugInfo {
    private static final Logger LOG = Logger.getLogger(NakedObjectReflectorAbstract.class);
    private final NakedObjectConfiguration configuration;
    private final ClassSubstitutor classSubstitutor;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModelFacets programmingModelFacets;
    private final FacetProcessor facetProcessor;
    private final FacetDecoratorSet facetDecoratorSet;
    private RuntimeContext runtimeContext;
    private SpecificationTraverser specificationTraverser;
    private List<Class<?>> serviceClasses = new ArrayList();
    private MetaModelValidator metaModelValidator;
    private final SpecificationCache cache;

    public NakedObjectReflectorAbstract(NakedObjectConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, SpecificationTraverser specificationTraverser, ProgrammingModelFacets programmingModelFacets, Set<FacetDecorator> facetDecorators, MetaModelValidator metaModelValidator) {
        Ensure.ensureThatArg(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(classSubstitutor, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(collectionTypeRegistry, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(programmingModelFacets, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(specificationTraverser, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(facetDecorators, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(metaModelValidator, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.classSubstitutor = classSubstitutor;
        this.collectionTypeRegistry = collectionTypeRegistry;
        this.programmingModelFacets = programmingModelFacets;
        this.specificationTraverser = specificationTraverser;
        this.facetDecoratorSet = new FacetDecoratorSet();
        for (FacetDecorator facetDecorator : facetDecorators) {
            this.facetDecoratorSet.add(facetDecorator);
        }
        this.metaModelValidator = metaModelValidator;
        this.facetProcessor = new FacetProcessor(configuration, this, collectionTypeRegistry, programmingModelFacets);
        this.cache = new SimpleSpecificationCache();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)("finalizing reflector factory " + this));
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("initialising " + this));
        }
        if (this.runtimeContext == null) {
            this.runtimeContext = new RuntimeContextNoRuntime();
        }
        this.injectInto(this.runtimeContext);
        this.injectInto(this.specificationTraverser);
        this.injectInto(this.metaModelValidator);
        this.runtimeContext.injectInto(this.facetProcessor);
        this.facetDecoratorSet.init();
        this.classSubstitutor.init();
        this.collectionTypeRegistry.init();
        this.specificationTraverser.init();
        this.facetProcessor.init();
        this.programmingModelFacets.init();
        this.metaModelValidator.init();
        this.primeCache();
        this.metaModelValidator.validate();
    }

    private void primeCache() {
        for (Class<?> serviceClass : this.serviceClasses) {
            this.internalLoadSpecification(serviceClass);
        }
        this.loadAllSpecifications();
    }

    private void loadAllSpecifications() {
        List<Class<?>> newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        while (newlyDiscoveredClasses.size() > 0) {
            for (Class<?> newClass : newlyDiscoveredClasses) {
                this.internalLoadSpecification(newClass);
            }
            newlyDiscoveredClasses = this.newlyDiscoveredClasses();
        }
    }

    private List<Class<?>> newlyDiscoveredClasses() {
        ArrayList newlyDiscoveredClasses = new ArrayList();
        NakedObjectSpecification[] noSpecs = this.allSpecifications();
        try {
            for (NakedObjectSpecification noSpec : noSpecs) {
                this.getSpecificationTraverser().traverseReferencedClasses(noSpec, newlyDiscoveredClasses);
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NakedObjectException(ex);
        }
        return newlyDiscoveredClasses;
    }

    @Override
    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        this.getCache().clear();
        this.facetDecoratorSet.shutdown();
    }

    @Override
    public final NakedObjectSpecification loadSpecification(String className) {
        Ensure.ensureThatArg(className, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), "specification class name must be specified");
        try {
            Class<?> cls = this.loadBuiltIn(className);
            return this.internalLoadSpecification(cls);
        }
        catch (ClassNotFoundException e) {
            NakedObjectSpecification spec = this.getCache().get(className);
            if (spec == null) {
                throw new NakedObjectException("No such class available: " + className);
            }
            return spec;
        }
    }

    @Override
    public NakedObjectSpecification loadSpecification(Class<?> type) {
        return this.internalLoadSpecification(type);
    }

    private NakedObjectSpecification internalLoadSpecification(Class<?> type) {
        Class<?> substitutedType = this.getClassSubstitutor().getClass(type);
        NakedObjectSpecification nakedObjectSpecification = substitutedType != null ? this.loadSpecificationForSubstitutedClass(substitutedType) : null;
        return nakedObjectSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NakedObjectSpecification loadSpecificationForSubstitutedClass(Class<?> type) {
        SpecificationCache specificationCache;
        Assert.assertNotNull(type);
        String typeName = type.getName();
        SpecificationCache specificationCache2 = specificationCache = this.getCache();
        synchronized (specificationCache2) {
            NakedObjectSpecification spec = specificationCache.get(typeName);
            if (spec != null) {
                return spec;
            }
            NakedObjectSpecification specification = this.createSpecification(type);
            if (specification == null) {
                throw new NakedObjectException("Failed to create specification for class " + typeName);
            }
            specificationCache.cache(typeName, specification);
            this.introspectSpecificationIfRequired(specification);
            return specification;
        }
    }

    public boolean loadSpecifications(List<Class<?>> typesToLoad, Class<?> typeToIgnore) {
        boolean anyLoadedAsNull = false;
        for (Class<?> typeToLoad : typesToLoad) {
            if (typeToLoad == typeToIgnore) continue;
            NakedObjectSpecification noSpec = this.internalLoadSpecification(typeToLoad);
            boolean loadedAsNull = noSpec == null;
            anyLoadedAsNull = loadedAsNull || anyLoadedAsNull;
        }
        return anyLoadedAsNull;
    }

    public boolean loadSpecifications(List<Class<?>> typesToLoad) {
        return this.loadSpecifications(typesToLoad, null);
    }

    protected NakedObjectSpecification createSpecification(Class<?> cls) {
        if (NakedObjectList.class.isAssignableFrom(cls)) {
            return new InstanceCollectionSpecification(this, this.getRuntimeContext());
        }
        return new JavaSpecification(cls, this, this.getRuntimeContext());
    }

    private Class<?> loadBuiltIn(String className) throws ClassNotFoundException {
        Class<?> builtIn = JavaClassUtils.getBuiltIn(className);
        if (builtIn != null) {
            return builtIn;
        }
        return Class.forName(className);
    }

    @Override
    public NakedObjectSpecification[] allSpecifications() {
        return this.getCache().allSpecifications();
    }

    @Override
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Override
    public boolean loaded(String fullyQualifiedClassName) {
        return this.getCache().get(fullyQualifiedClassName) != null;
    }

    private NakedObjectSpecification introspectSpecificationIfRequired(NakedObjectSpecification spec) {
        IntrospectableSpecification introspectableSpec;
        if (spec instanceof IntrospectableSpecification && !(introspectableSpec = (IntrospectableSpecification)((Object)spec)).isIntrospected()) {
            introspectableSpec.introspect(this.facetDecoratorSet);
        }
        return spec;
    }

    @Override
    public void injectInto(Object candidate) {
        Class<?> candidateClass = candidate.getClass();
        if (SpecificationLoaderAware.class.isAssignableFrom(candidateClass)) {
            SpecificationLoaderAware cast = (SpecificationLoaderAware)SpecificationLoaderAware.class.cast(candidate);
            cast.setSpecificationLoader(this);
        }
        this.getClassSubstitutor().injectInto(candidate);
        this.getCollectionTypeRegistry().injectInto(candidate);
    }

    @Override
    public void debugData(DebugString str) {
        this.facetDecoratorSet.debugData(str);
        str.appendln();
        str.appendTitle("Specifications");
        NakedObjectSpecification[] specs = this.allSpecifications();
        Arrays.sort(specs, new Comparator<NakedObjectSpecification>(){

            @Override
            public int compare(NakedObjectSpecification s1, NakedObjectSpecification s2) {
                return s1.getShortName().compareToIgnoreCase(s2.getShortName());
            }
        });
        for (int i = 0; i < specs.length; ++i) {
            NakedObjectSpecification specification = specs[i];
            str.append(specification.isAbstract() ? "A" : ".");
            str.append(specification.isService() ? "S" : ".");
            str.append(SpecificationFacets.isBoundedSet(specification) ? "B" : ".");
            str.append(specification.isCollection() ? "C" : ".");
            str.append(specification.isObject() ? "O" : ".");
            str.append(".");
            str.append(specification.isParseable() ? "P" : ".");
            str.append(specification.isEncodeable() ? "E" : ".");
            str.append(specification.isValueOrIsAggregated() ? "A" : ".");
            str.append(!specification.isCollectionOrIsAggregated() ? "I" : ".");
            str.append("  ");
            str.append(specification.getShortName());
            str.append("  [fqc=");
            str.append(specification.getFullName());
            str.append(",type=");
            str.append(specification.getClass().getName());
            str.appendln("]");
        }
    }

    @Override
    public String debugTitle() {
        return "Reflector";
    }

    public FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private SpecificationCache getCache() {
        return this.cache;
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public List<Class<?>> getServiceClasses() {
        return Collections.unmodifiableList(this.serviceClasses);
    }

    @Override
    public void setServiceClasses(List<Class<?>> serviceClasses) {
        this.serviceClasses = serviceClasses;
    }

    public NakedObjectConfiguration getNakedObjectConfiguration() {
        return this.configuration;
    }

    @Override
    public ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    public CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    @Override
    public SpecificationTraverser getSpecificationTraverser() {
        return this.specificationTraverser;
    }

    @Override
    public ProgrammingModelFacets getProgrammingModelFacets() {
        return this.programmingModelFacets;
    }

    public Set<FacetDecorator> getFacetDecoratorSet() {
        return this.facetDecoratorSet.getFacetDecorators();
    }

    @Override
    public MetaModelValidator getMetaModelValidator() {
        return this.metaModelValidator;
    }
}

