/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResultSet;
import org.nakedobjects.metamodel.exceptions.ModelException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.nakedobjects.metamodel.facets.actions.choices.ActionParameterChoicesFacet;
import org.nakedobjects.metamodel.facets.actions.debug.DebugFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionParameterDefaultsFacet;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.interactions.ActionArgumentContext;
import org.nakedobjects.metamodel.interactions.ActionInvocationContext;
import org.nakedobjects.metamodel.interactions.ActionUsabilityContext;
import org.nakedobjects.metamodel.interactions.ActionVisibilityContext;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.interactions.UsabilityContext;
import org.nakedobjects.metamodel.interactions.VisibilityContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectMemberAbstract;
import org.nakedobjects.metamodel.services.container.query.QueryFindAllInstances;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.Target;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionType;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionParameterAbstract;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionParameterParseable;
import org.nakedobjects.metamodel.specloader.internal.OneToOneActionParameterImpl;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionParamPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NakedObjectActionImpl
extends NakedObjectMemberAbstract
implements NakedObjectAction {
    private static final Logger LOG = Logger.getLogger(NakedObjectActionImpl.class);
    private final NakedObjectActionPeer nakedObjectActionPeer;
    private NakedObjectActionParameter[] parameters;
    private boolean knownWhetherContributed = false;
    private boolean contributed;

    public static NakedObjectActionType getType(String typeStr) {
        NakedObjectActionType type = NakedObjectActionType.valueOf(typeStr);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    public NakedObjectActionImpl(String methodId, NakedObjectActionPeer nakedObjectActionPeer, RuntimeContext runtimeContext) {
        super(methodId, nakedObjectActionPeer, NakedObjectMemberAbstract.MemberType.ACTION, runtimeContext);
        this.nakedObjectActionPeer = nakedObjectActionPeer;
    }

    @Override
    public NakedObjectSpecification getSpecification() {
        return null;
    }

    @Override
    public NakedObjectSpecification getReturnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getReturnType();
    }

    @Override
    public boolean hasReturn() {
        return this.getReturnType() != null;
    }

    @Override
    public NakedObjectSpecification getOnType() {
        ActionInvocationFacet facet = this.getActionInvocationFacet();
        return facet.getOnType();
    }

    @Override
    public NakedObjectAction[] getActions() {
        return new NakedObjectAction[0];
    }

    @Override
    public Instance getInstance(NakedObject nakedObject) {
        NakedObjectActionImpl specification = this;
        return nakedObject.getInstance(specification);
    }

    @Override
    public Target getTarget() {
        ExecutedFacet facet = this.getFacet(ExecutedFacet.class);
        ExecutedFacet.Where executeWhere = facet.value();
        if (executeWhere == ExecutedFacet.Where.LOCALLY) {
            return NakedObjectActionConstants.LOCAL;
        }
        if (executeWhere == ExecutedFacet.Where.REMOTELY) {
            return NakedObjectActionConstants.REMOTE;
        }
        if (executeWhere == ExecutedFacet.Where.DEFAULT) {
            return NakedObjectActionConstants.DEFAULT;
        }
        throw new UnknownTypeException(executeWhere);
    }

    @Override
    public NakedObjectActionType getType() {
        Facet facet = this.getFacet(DebugFacet.class);
        if (facet != null) {
            return NakedObjectActionConstants.DEBUG;
        }
        facet = this.getFacet(ExplorationFacet.class);
        if (facet != null) {
            return NakedObjectActionConstants.EXPLORATION;
        }
        return NakedObjectActionConstants.USER;
    }

    @Override
    public boolean isContributed() {
        if (!this.knownWhetherContributed) {
            this.contributed = this.determineWhetherContributed();
            this.knownWhetherContributed = true;
        }
        return this.contributed;
    }

    private boolean determineWhetherContributed() {
        if (this.getOnType().isService() && this.getParameterCount() > 0) {
            NakedObjectActionParameter[] params = this.getParameters();
            for (int i = 0; i < params.length; ++i) {
                if (!params[i].isObject()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getParameterCount() {
        return this.nakedObjectActionPeer.getParameters().length;
    }

    @Override
    public boolean promptForParameters(NakedObject target) {
        NakedObjectActionParameter[] parameters = this.getParameters();
        if (this.isContributed() && !target.getSpecification().isService()) {
            return this.getParameterCount() > 1 || !target.getSpecification().isOfType(parameters[0].getSpecification());
        }
        return this.getParameterCount() > 0;
    }

    @Override
    public synchronized NakedObjectActionParameter[] getParameters() {
        if (this.parameters == null) {
            int parameterCount = this.getParameterCount();
            NakedObjectActionParameter[] parameters = new NakedObjectActionParameter[parameterCount];
            NakedObjectActionParamPeer[] paramPeers = this.nakedObjectActionPeer.getParameters();
            for (int i = 0; i < parameterCount; ++i) {
                NakedObjectSpecification specification = paramPeers[i].getSpecification();
                if (specification.isParseable()) {
                    parameters[i] = new NakedObjectActionParameterParseable(i, this, paramPeers[i]);
                    continue;
                }
                if (specification.isObject()) {
                    parameters[i] = new OneToOneActionParameterImpl(i, this, paramPeers[i]);
                    continue;
                }
                if (specification.isCollection()) {
                    throw new UnknownTypeException("collections not supported as parameters: " + this.getIdentifier());
                }
                throw new UnknownTypeException(specification);
            }
            this.parameters = parameters;
        }
        return this.parameters;
    }

    @Override
    public synchronized NakedObjectSpecification[] getParameterTypes() {
        NakedObjectActionParameter[] parameters;
        ArrayList<NakedObjectSpecification> parameterTypes = new ArrayList<NakedObjectSpecification>();
        for (NakedObjectActionParameter parameter : parameters = this.getParameters()) {
            parameterTypes.add(parameter.getSpecification());
        }
        return parameterTypes.toArray(new NakedObjectSpecification[0]);
    }

    @Override
    public NakedObjectActionParameter[] getParameters(Filter<NakedObjectActionParameter> filter) {
        NakedObjectActionParameter[] allParameters = this.getParameters();
        NakedObjectActionParameter[] selectedParameters = new NakedObjectActionParameter[allParameters.length];
        int v = 0;
        for (int i = 0; i < allParameters.length; ++i) {
            if (!filter.accept(allParameters[i])) continue;
            selectedParameters[v++] = allParameters[i];
        }
        NakedObjectActionParameter[] parameters = new NakedObjectActionParameter[v];
        System.arraycopy(selectedParameters, 0, parameters, 0, v);
        return parameters;
    }

    private NakedObjectActionParameter getParameter(int position) {
        NakedObjectActionParameter[] parameters = this.getParameters();
        if (position >= parameters.length) {
            throw new IllegalArgumentException("getParameter(int): only " + parameters.length + " parameters, position=" + position);
        }
        return parameters[position];
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject targetNakedObject) {
        return new ActionVisibilityContext(session, invocationMethod, targetNakedObject, this.getIdentifier());
    }

    @Override
    public Consent isVisible(AuthenticationSession session, NakedObject target) {
        return super.isVisible(session, this.realTarget(target));
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject targetNakedObject) {
        return new ActionUsabilityContext(session, invocationMethod, targetNakedObject, this.getIdentifier());
    }

    @Override
    public Consent isUsable(AuthenticationSession session, NakedObject target) {
        return super.isUsable(session, this.realTarget(target));
    }

    @Override
    public Consent isProposedArgumentSetValid(NakedObject object, NakedObject[] proposedArguments) {
        return this.isProposedArgumentSetValidResultSet(object, proposedArguments).createConsent();
    }

    private InteractionResultSet isProposedArgumentSetValidResultSet(NakedObject object, NakedObject[] proposedArguments) {
        InteractionInvocationMethod invocationMethod = InteractionInvocationMethod.BY_USER;
        InteractionResultSet resultSet = new InteractionResultSet();
        NakedObjectActionParameter[] actionParameters = this.getParameters();
        if (proposedArguments != null) {
            for (int i = 0; i < proposedArguments.length; ++i) {
                ActionArgumentContext ic = actionParameters[i].createProposedArgumentInteractionContext(this.getAuthenticationSession(), invocationMethod, object, proposedArguments, i);
                InteractionUtils.isValidResultSet(this.getParameter(i), ic, resultSet);
            }
        }
        if (resultSet.isAllowed()) {
            ActionInvocationContext ic = this.createActionInvocationInteractionContext(this.getAuthenticationSession(), invocationMethod, object, proposedArguments);
            InteractionUtils.isValidResultSet(this, ic, resultSet);
        }
        return resultSet;
    }

    @Override
    public ActionInvocationContext createActionInvocationInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject targetObject, NakedObject[] proposedArguments) {
        return new ActionInvocationContext(this.getAuthenticationSession(), invocationMethod, targetObject, this.getIdentifier(), proposedArguments);
    }

    @Override
    public NakedObject execute(NakedObject object, NakedObject[] parameters) {
        LOG.debug((Object)("execute action " + object + "." + this.getId()));
        NakedObject[] params = this.realParameters(object, parameters);
        NakedObject target = this.realTarget(object);
        ActionInvocationFacet facet = this.getFacet(ActionInvocationFacet.class);
        return facet.invoke(target, params);
    }

    private ActionInvocationFacet getActionInvocationFacet() {
        return this.nakedObjectActionPeer.getFacet(ActionInvocationFacet.class);
    }

    @Override
    public NakedObject realTarget(NakedObject target) {
        if (target == null) {
            return this.findService();
        }
        if (target.getSpecification().isService()) {
            return target;
        }
        if (this.isContributed()) {
            return this.findService();
        }
        return target;
    }

    private NakedObject findService() {
        List<NakedObject> services = this.getRuntimeContext().getServices();
        for (NakedObject serviceAdapter : services) {
            if (serviceAdapter.getSpecification() != this.getOnType()) continue;
            return serviceAdapter;
        }
        throw new NakedObjectException("failed to find service for action " + this.getName());
    }

    private NakedObject[] realParameters(NakedObject target, NakedObject[] parameters) {
        NakedObject[] nakedObjectArray;
        if (parameters != null) {
            return parameters;
        }
        if (this.isContributed()) {
            NakedObject[] nakedObjectArray2 = new NakedObject[1];
            nakedObjectArray = nakedObjectArray2;
            nakedObjectArray2[0] = target;
        } else {
            nakedObjectArray = new NakedObject[]{};
        }
        return nakedObjectArray;
    }

    @Override
    public NakedObject[] getDefaults(NakedObject target) {
        int i;
        Object[] parameterDefaultPojos;
        NakedObject realTarget = this.realTarget(target);
        int parameterCount = this.getParameterCount();
        NakedObjectActionParameter[] parameters = this.getParameters();
        ActionDefaultsFacet facet = this.getFacet(ActionDefaultsFacet.class);
        if (!facet.isNoop()) {
            parameterDefaultPojos = facet.getDefaults(realTarget);
            if (parameterDefaultPojos.length != parameterCount) {
                throw new ModelException("Defaults array of incompatible size; expected " + parameterCount + " elements, but was " + parameterDefaultPojos.length + " for " + facet);
            }
            for (i = 0; i < parameterCount; ++i) {
                NakedObjectSpecification parameterSpec;
                NakedObjectSpecification componentSpec;
                if (parameterDefaultPojos[i] == null || (componentSpec = this.getRuntimeContext().getSpecificationLoader().loadSpecification(parameterDefaultPojos[i].getClass())).isOfType(parameterSpec = parameters[i].getSpecification())) continue;
                throw new ModelException("Defaults type incompatible with parameter " + (i + 1) + " type; expected " + parameterSpec.getFullName() + ", but was " + componentSpec.getFullName());
            }
        } else {
            parameterDefaultPojos = new Object[parameterCount];
            for (i = 0; i < parameterCount; ++i) {
                ActionParameterDefaultsFacet paramFacet = parameters[i].getFacet(ActionParameterDefaultsFacet.class);
                parameterDefaultPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getDefault(realTarget) : null;
            }
        }
        NakedObject[] parameterDefaultAdapters = new NakedObject[parameterCount];
        if (parameterDefaultPojos != null) {
            for (int i2 = 0; i2 < parameterCount; ++i2) {
                parameterDefaultAdapters[i2] = this.adapterFor(parameterDefaultPojos[i2]);
            }
        }
        if (this.isContributed() && target != null) {
            for (int i3 = 0; i3 < parameterCount; ++i3) {
                if (!target.getSpecification().isOfType(parameters[i3].getSpecification())) continue;
                parameterDefaultAdapters[i3] = target;
            }
        }
        return parameterDefaultAdapters;
    }

    private NakedObject adapterFor(Object pojo) {
        return pojo == null ? null : this.getRuntimeContext().adapterFor(pojo);
    }

    @Override
    public NakedObject[][] getChoices(NakedObject target) {
        Object[][] parameterChoicesPojos;
        NakedObject realTarget = this.realTarget(target);
        int parameterCount = this.getParameterCount();
        ActionChoicesFacet facet = this.getFacet(ActionChoicesFacet.class);
        NakedObjectActionParameter[] parameters = this.getParameters();
        if (!facet.isNoop()) {
            parameterChoicesPojos = facet.getChoices(realTarget);
            if (parameterChoicesPojos == null) {
                parameterChoicesPojos = new Object[parameterCount][];
            } else if (parameterChoicesPojos.length != parameterCount) {
                throw new ModelException("Choices array of incompatible size; expected " + parameterCount + " elements, but was " + parameterChoicesPojos.length + " for " + facet);
            }
        } else {
            parameterChoicesPojos = new Object[parameterCount][];
            for (int i = 0; i < parameterCount; ++i) {
                ActionParameterChoicesFacet paramFacet = parameters[i].getFacet(ActionParameterChoicesFacet.class);
                parameterChoicesPojos[i] = paramFacet != null && !paramFacet.isNoop() ? paramFacet.getChoices(realTarget) : new Object[0];
            }
        }
        NakedObject[][] parameterChoicesAdapters = new NakedObject[parameterCount][];
        for (int i = 0; i < parameterCount; ++i) {
            NakedObjectSpecification paramSpec = parameters[i].getSpecification();
            if (parameterChoicesPojos[i] != null && parameterChoicesPojos[i].length > 0) {
                NakedObjectActionParameterAbstract.checkChoicesType(this.getRuntimeContext(), parameterChoicesPojos[i], paramSpec);
                parameterChoicesAdapters[i] = new NakedObject[parameterChoicesPojos[i].length];
                for (int j = 0; j < parameterChoicesPojos[i].length; ++j) {
                    parameterChoicesAdapters[i][j] = this.adapterFor(parameterChoicesPojos[i][j]);
                }
            } else if (SpecificationFacets.isBoundedSet(paramSpec)) {
                QueryFindAllInstances query = new QueryFindAllInstances(paramSpec);
                List<NakedObject> allInstancesAdapter = this.getRuntimeContext().allMatchingQuery(query);
                parameterChoicesAdapters[i] = new NakedObject[allInstancesAdapter.size()];
                int j = 0;
                for (NakedObject adapter : allInstancesAdapter) {
                    parameterChoicesAdapters[i][j++] = adapter;
                }
            } else if (paramSpec.isObject()) {
                parameterChoicesAdapters[i] = new NakedObject[0];
            } else {
                throw new UnknownTypeException(paramSpec);
            }
            if (parameterChoicesAdapters[i].length != 0) continue;
            parameterChoicesAdapters[i] = null;
        }
        return parameterChoicesAdapters;
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        this.nakedObjectActionPeer.debugData(debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Action [");
        sb.append(super.toString());
        sb.append(",type=");
        sb.append((Object)this.getType());
        sb.append(",returns=");
        sb.append(this.getReturnType());
        sb.append(",parameters={");
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.getParameters()[i].getSpecification().getShortName());
        }
        sb.append("}]");
        return sb.toString();
    }
}

