/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal.facetprocessor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.ListUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetFactory;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodFilteringFacetFactory;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.MethodRemoverConstants;
import org.nakedobjects.metamodel.facets.PropertyOrCollectionIdentifyingFacetFactory;
import org.nakedobjects.metamodel.java5.MethodPrefixBasedFacetFactory;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetProcessor
implements RuntimeContextAware {
    private final NakedObjectConfiguration configuration;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModelFacets programmingModelFacets;
    private final SpecificationLoader specificationLoader;
    private RuntimeContext runtimeContext;
    private final Map<Class<? extends FacetFactory>, FacetFactory> factoryByFactoryType = new HashMap<Class<? extends FacetFactory>, FacetFactory>();
    private final List<FacetFactory> factories = new ArrayList<FacetFactory>();
    private List<String> methodPrefixes;
    private List<MethodFilteringFacetFactory> methodFilteringFactories;
    private List<PropertyOrCollectionIdentifyingFacetFactory> propertyOrCollectionIdentifyingFactories;
    private Map<NakedObjectFeatureType, List<FacetFactory>> factoryListByFeatureType = null;

    public FacetProcessor(NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, CollectionTypeRegistry collectionTypeRegistry, ProgrammingModelFacets programmingModelFacets) {
        Ensure.ensureThatState(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState(collectionTypeRegistry, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState(programmingModelFacets, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatState(specificationLoader, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.specificationLoader = specificationLoader;
        this.programmingModelFacets = programmingModelFacets;
        this.collectionTypeRegistry = collectionTypeRegistry;
    }

    public void init() {
        Ensure.ensureThatState(this.runtimeContext, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.programmingModelFacets.init();
        List<FacetFactory> facetFactoryList = this.programmingModelFacets.getList();
        for (FacetFactory facetFactory : facetFactoryList) {
            this.registerFactory(facetFactory);
        }
    }

    public void shutdown() {
    }

    public void registerFactory(FacetFactory factory) {
        this.clearCaches();
        this.factoryByFactoryType.put(factory.getClass(), factory);
        this.factories.add(factory);
        this.injectDependenciesInto(factory);
    }

    public void injectDependenciesInto(FacetFactory factory) {
        this.getCollectionTypeRepository().injectInto(factory);
        this.getSpecificationLoader().injectInto(factory);
        this.getRuntimeContext().injectInto(factory);
        this.getNakedObjectConfiguration().injectInto(factory);
    }

    public FacetFactory getFactoryByFactoryType(Class<? extends FacetFactory> factoryType) {
        return this.factoryByFactoryType.get(factoryType);
    }

    public Set<Method> findPropertyOrCollectionCandidateAccessors(Method[] methods, Set<Method> candidates) {
        this.cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method == null) continue;
            for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.propertyOrCollectionIdentifyingFactories) {
                if (!facetFactory.isPropertyOrCollectionAccessorCandidate(method)) continue;
                candidates.add(method);
            }
        }
        return candidates;
    }

    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.propertyOrCollectionIdentifyingFactories) {
            facetFactory.findAndRemovePropertyAccessors(methodRemover, methodListToAppendTo);
        }
    }

    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        this.cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired();
        for (PropertyOrCollectionIdentifyingFacetFactory facetFactory : this.propertyOrCollectionIdentifyingFactories) {
            facetFactory.findAndRemoveCollectionAccessors(methodRemover, methodListToAppendTo);
        }
    }

    public boolean recognizes(Method method) {
        this.cacheMethodPrefixesIfRequired();
        String methodName = method.getName();
        for (String prefix : this.methodPrefixes) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        this.cacheMethodFilteringFacetFactoriesIfRequired();
        for (MethodFilteringFacetFactory factory : this.methodFilteringFactories) {
            if (!factory.recognizes(method)) continue;
            return true;
        }
        return false;
    }

    public boolean process(Class<?> cls, MethodRemover methodRemover, FacetHolder facetHolder) {
        boolean facetsAdded = false;
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(NakedObjectFeatureType.OBJECT);
        for (FacetFactory facetFactory : factoryList) {
            facetsAdded = facetFactory.process(cls, this.removerElseNullRemover(methodRemover), facetHolder) | facetsAdded;
        }
        return facetsAdded;
    }

    public boolean process(Method method, MethodRemover methodRemover, FacetHolder facetHolder, NakedObjectFeatureType featureType) {
        boolean facetsAdded = false;
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(featureType);
        for (FacetFactory facetFactory : factoryList) {
            facetsAdded = facetFactory.process(method, this.removerElseNullRemover(methodRemover), facetHolder) | facetsAdded;
        }
        return facetsAdded;
    }

    public boolean processParams(Method method, int paramNum, FacetHolder facetHolder) {
        boolean facetsAdded = false;
        List<FacetFactory> factoryList = this.getFactoryListByFeatureType(NakedObjectFeatureType.ACTION_PARAMETER);
        for (FacetFactory facetFactory : factoryList) {
            facetsAdded = facetFactory.processParams(method, paramNum, facetHolder) | facetsAdded;
        }
        return facetsAdded;
    }

    private List<FacetFactory> getFactoryListByFeatureType(NakedObjectFeatureType featureType) {
        this.cacheByFeatureTypeIfRequired();
        return this.factoryListByFeatureType.get(featureType);
    }

    private void clearCaches() {
        this.factoryListByFeatureType = null;
        this.methodPrefixes = null;
        this.methodFilteringFactories = null;
        this.propertyOrCollectionIdentifyingFactories = null;
    }

    private synchronized void cacheByFeatureTypeIfRequired() {
        if (this.factoryListByFeatureType != null) {
            return;
        }
        this.factoryListByFeatureType = new HashMap<NakedObjectFeatureType, List<FacetFactory>>();
        for (FacetFactory factory : this.factories) {
            NakedObjectFeatureType[] featureTypes = factory.getFeatureTypes();
            for (int i = 0; i < featureTypes.length; ++i) {
                List factoryList = FacetProcessor.getList(this.factoryListByFeatureType, featureTypes[i]);
                factoryList.add(factory);
            }
        }
    }

    private synchronized void cacheMethodPrefixesIfRequired() {
        if (this.methodPrefixes != null) {
            return;
        }
        this.methodPrefixes = new ArrayList<String>();
        for (FacetFactory facetFactory : this.factories) {
            if (!(facetFactory instanceof MethodPrefixBasedFacetFactory)) continue;
            MethodPrefixBasedFacetFactory methodPrefixBasedFacetFactory = (MethodPrefixBasedFacetFactory)facetFactory;
            ListUtils.combine(this.methodPrefixes, methodPrefixBasedFacetFactory.getPrefixes());
        }
    }

    private synchronized void cacheMethodFilteringFacetFactoriesIfRequired() {
        if (this.methodFilteringFactories != null) {
            return;
        }
        this.methodFilteringFactories = new ArrayList<MethodFilteringFacetFactory>();
        for (FacetFactory factory : this.factories) {
            if (!(factory instanceof MethodFilteringFacetFactory)) continue;
            MethodFilteringFacetFactory methodFilteringFacetFactory = (MethodFilteringFacetFactory)factory;
            this.methodFilteringFactories.add(methodFilteringFacetFactory);
        }
    }

    private synchronized void cachePropertyOrCollectionIdentifyingFacetFactoriesIfRequired() {
        if (this.propertyOrCollectionIdentifyingFactories != null) {
            return;
        }
        this.propertyOrCollectionIdentifyingFactories = new ArrayList<PropertyOrCollectionIdentifyingFacetFactory>();
        for (FacetFactory factory : this.factories) {
            if (!(factory instanceof PropertyOrCollectionIdentifyingFacetFactory)) continue;
            PropertyOrCollectionIdentifyingFacetFactory identifyingFacetFactory = (PropertyOrCollectionIdentifyingFacetFactory)factory;
            this.propertyOrCollectionIdentifyingFactories.add(identifyingFacetFactory);
        }
    }

    private static <T> List<T> getList(Map map, Object key) {
        ArrayList list = (ArrayList)map.get(key);
        if (list == null) {
            list = new ArrayList();
            map.put(key, list);
        }
        return list;
    }

    private MethodRemover removerElseNullRemover(MethodRemover methodRemover) {
        return methodRemover != null ? methodRemover : MethodRemoverConstants.NULL;
    }

    private NakedObjectConfiguration getNakedObjectConfiguration() {
        return this.configuration;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    private CollectionTypeRegistry getCollectionTypeRepository() {
        return this.collectionTypeRegistry;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

