/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal.introspector;

import java.beans.Introspector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.commons.names.NameUtils;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facets.FacetFactory;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.MethodScope;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.object.facets.FacetsFacet;
import org.nakedobjects.metamodel.facets.ordering.OrderSet;
import org.nakedobjects.metamodel.facets.ordering.SimpleOrderSet;
import org.nakedobjects.metamodel.facets.ordering.actionorder.ActionOrderFacet;
import org.nakedobjects.metamodel.facets.ordering.fieldorder.FieldOrderFacet;
import org.nakedobjects.metamodel.facets.ordering.memberorder.DeweyOrderSet;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.NakedObjectReflectorAbstract;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.internal.facetprocessor.FacetProcessor;
import org.nakedobjects.metamodel.specloader.internal.introspector.MethodFinderUtils;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionParamPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaOneToManyAssociationPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaOneToOneAssociationPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectAssociationPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectMemberPeer;
import org.nakedobjects.metamodel.specloader.traverser.SpecificationTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaIntrospector {
    private static final Logger LOG = Logger.getLogger(JavaIntrospector.class);
    private static final Object[] NO_PARAMETERS = new Object[0];
    private static final Class<?>[] NO_PARAMETERS_TYPES = new Class[0];
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private final String className;
    private final Class<?> type;
    private final Method[] methods;
    private OrderSet orderedFields;
    private OrderSet orderedObjectActions;
    private OrderSet orderedClassActions;
    private final NakedObjectReflectorAbstract reflector;
    private final JavaSpecification javaSpecification;

    public JavaIntrospector(Class<?> type, JavaSpecification javaSpecification, NakedObjectReflectorAbstract reflector) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating JavaIntrospector for " + type));
        }
        Class<?> classComponentType = type.getComponentType();
        this.type = type;
        this.javaSpecification = javaSpecification;
        this.reflector = reflector;
        this.methods = type.getMethods();
        this.className = type.getName();
    }

    private SpecificationTraverser getSpecificationTraverser() {
        return this.reflector.getSpecificationTraverser();
    }

    private FacetProcessor getFacetProcessor() {
        return this.reflector.getFacetProcessor();
    }

    private ClassSubstitutor getClassSubstitutor() {
        return this.reflector.getClassSubstitutor();
    }

    public Class<?> getIntrospectedClass() {
        return this.type;
    }

    String className() {
        return this.className;
    }

    public String getFullName() {
        return this.type.getName();
    }

    public String[] getInterfaces() {
        return JavaClassUtils.getInterfaces(this.type);
    }

    public String getSuperclass() {
        return JavaClassUtils.getSuperclass(this.type);
    }

    public boolean isAbstract() {
        return JavaClassUtils.isAbstract(this.type);
    }

    public boolean isFinal() {
        return JavaClassUtils.isFinal(this.type);
    }

    public String shortName() {
        String name = this.type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public void introspectClass() {
        LOG.info((Object)("introspecting " + this.className()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("introspecting " + this.className() + ": class-level details"));
        }
        JavaIntrospectorMethodRemover methodRemover = new JavaIntrospectorMethodRemover();
        this.getFacetProcessor().process(this.type, methodRemover, this.javaSpecification);
        FacetsFacet facetsFacet = this.javaSpecification.getFacet(FacetsFacet.class);
        if (facetsFacet != null) {
            Class<? extends FacetFactory>[] facetFactories = facetsFacet.facetFactories();
            for (int i = 0; i < facetFactories.length; ++i) {
                FacetFactory facetFactory = null;
                try {
                    facetFactory = facetFactories[i].newInstance();
                }
                catch (InstantiationException e) {
                    throw new NakedObjectException(e);
                }
                catch (IllegalAccessException e) {
                    throw new NakedObjectException(e);
                }
                this.getFacetProcessor().injectDependenciesInto(facetFactory);
                facetFactory.process(this.type, (MethodRemover)methodRemover, (FacetHolder)this.javaSpecification);
            }
        }
    }

    public void introspectPropertiesAndCollections() {
        LOG.debug((Object)("introspecting " + this.className() + ": properties and collections"));
        NakedObjectMemberPeer[] findFieldMethods = this.findAndCreateFieldPeers();
        FieldOrderFacet fieldOrderFacet = this.javaSpecification.getFacet(FieldOrderFacet.class);
        String fieldOrder = fieldOrderFacet == null ? null : fieldOrderFacet.value();
        if (fieldOrder == null) {
            fieldOrder = this.invokeSortOrderMethod("field");
        }
        this.orderedFields = this.createOrderSet(fieldOrder, findFieldMethods);
    }

    public void introspectActions() {
        LOG.debug((Object)("introspecting " + this.className() + ": actions"));
        NakedObjectMemberPeer[] actionPeers = this.findActionMethodPeers(MethodScope.OBJECT);
        ActionOrderFacet actionOrderFacet = this.javaSpecification.getFacet(ActionOrderFacet.class);
        String actionOrder = actionOrderFacet == null ? null : actionOrderFacet.value();
        if (actionOrder == null) {
            actionOrder = this.invokeSortOrderMethod("action");
        }
        this.orderedObjectActions = this.createOrderSet(actionOrder, actionPeers);
        NakedObjectMemberPeer[] findClassActionMethods = this.findActionMethodPeers(MethodScope.CLASS);
        actionOrder = null;
        if (actionOrder == null) {
            actionOrder = this.invokeSortOrderMethod("classAction");
        }
        this.orderedClassActions = this.createOrderSet(actionOrder, findClassActionMethods);
    }

    private NakedObjectAssociationPeer[] findAndCreateFieldPeers() {
        LOG.debug((Object)("  looking for fields for " + this.type));
        Set<Method> propertyOrCollectionCandidates = this.getFacetProcessor().findPropertyOrCollectionCandidateAccessors(this.methods, new HashSet<Method>());
        ArrayList typesToLoad = new ArrayList();
        for (Method method : propertyOrCollectionCandidates) {
            this.getSpecificationTraverser().traverseTypes(method, typesToLoad);
        }
        this.reflector.loadSpecifications(typesToLoad, this.type);
        ArrayList<NakedObjectAssociationPeer> fieldPeers = new ArrayList<NakedObjectAssociationPeer>();
        this.findAndRemoveCollectionAccessorsAndCreateCorrespondingFieldPeers(fieldPeers);
        this.findAndRemovePropertyAccessorsAndCreateCorrespondingFieldPeers(fieldPeers);
        return this.toArray(fieldPeers);
    }

    private NakedObjectAssociationPeer[] toArray(List<NakedObjectAssociationPeer> fields) {
        return fields.toArray(new NakedObjectAssociationPeer[0]);
    }

    private void findAndRemoveCollectionAccessorsAndCreateCorrespondingFieldPeers(List<NakedObjectAssociationPeer> associationPeers) {
        ArrayList<Method> collectionAccessors = new ArrayList<Method>();
        this.getFacetProcessor().findAndRemoveCollectionAccessors(new JavaIntrospectorMethodRemover(), collectionAccessors);
        this.createCollectionPeersFromAccessors(collectionAccessors, associationPeers);
    }

    private void findAndRemovePropertyAccessorsAndCreateCorrespondingFieldPeers(List<NakedObjectAssociationPeer> fields) {
        ArrayList<Method> propertyAccessors = new ArrayList<Method>();
        this.getFacetProcessor().findAndRemovePropertyAccessors(new JavaIntrospectorMethodRemover(), propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, GET_PREFIX, Object.class, 0, propertyAccessors);
        this.findAndRemovePrefixedNonVoidMethods(MethodScope.OBJECT, IS_PREFIX, Boolean.class, 0, propertyAccessors);
        this.createPropertyPeersFromAccessors(propertyAccessors, fields);
    }

    private void createCollectionPeersFromAccessors(List<Method> collectionAccessors, List<NakedObjectAssociationPeer> associationPeerListToAppendto) {
        for (Method getMethod : collectionAccessors) {
            LOG.debug((Object)("  identified one-many association method " + getMethod));
            String capitalizedName = NameUtils.javaBaseName(getMethod.getName());
            String collectionNameName = Introspector.decapitalize(capitalizedName);
            Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)this.className(), (String)collectionNameName);
            JavaOneToManyAssociationPeer collection = new JavaOneToManyAssociationPeer(identifier, this.getSpecificationLoader());
            this.getFacetProcessor().process(getMethod, new JavaIntrospectorMethodRemover(), collection, NakedObjectFeatureType.COLLECTION);
            Class elementType = Object.class;
            TypeOfFacet typeOfFacet = collection.getFacet(TypeOfFacet.class);
            if (typeOfFacet != null) {
                elementType = typeOfFacet.value();
            }
            collection.setElementType(elementType);
            if (this.getClassSubstitutor().getClass(elementType) == null) continue;
            associationPeerListToAppendto.add(collection);
        }
    }

    private void createPropertyPeersFromAccessors(List<Method> propertyAccessors, List<NakedObjectAssociationPeer> associationPeerListToAppendto) throws ReflectionException {
        for (Method accessorMethod : propertyAccessors) {
            LOG.debug((Object)("  identified 1-1 association method " + accessorMethod));
            String capitalizedName = NameUtils.javaBaseName(accessorMethod.getName());
            String beanName = Introspector.decapitalize(capitalizedName);
            Class<?> returnType = accessorMethod.getReturnType();
            if (this.getClassSubstitutor().getClass(returnType) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("one-to-one association " + capitalizedName + " ->" + accessorMethod));
            }
            Identifier identifier = Identifier.propertyOrCollectionIdentifier((String)this.className, (String)beanName);
            JavaOneToOneAssociationPeer associationPeer = new JavaOneToOneAssociationPeer(identifier, returnType, this.getSpecificationLoader());
            this.getFacetProcessor().process(accessorMethod, new JavaIntrospectorMethodRemover(), associationPeer, NakedObjectFeatureType.PROPERTY);
            associationPeerListToAppendto.add(associationPeer);
        }
    }

    private NakedObjectActionPeer[] findActionMethodPeers(MethodScope methodScope) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"  looking for action methods");
        }
        ArrayList<NakedObjectActionPeer> actionPeers = new ArrayList<NakedObjectActionPeer>();
        block0: for (int i = 0; i < this.methods.length; ++i) {
            Class[] parameterTypes;
            Method actionMethod;
            if (this.methods[i] == null || !MethodFinderUtils.inScope(methodScope, actionMethod = this.methods[i])) continue;
            ArrayList typesToLoad = new ArrayList();
            this.getSpecificationTraverser().traverseTypes(actionMethod, typesToLoad);
            boolean anyLoadedAsNull = this.reflector.loadSpecifications(typesToLoad);
            if (anyLoadedAsNull) continue;
            Class[] parameterClasses = parameterTypes = actionMethod.getParameterTypes();
            int numParameters = parameterClasses.length;
            JavaNakedObjectActionParamPeer[] actionParams = new JavaNakedObjectActionParamPeer[numParameters];
            for (int j = 0; j < numParameters; ++j) {
                NakedObjectSpecification paramSpec = this.getSpecificationLoader().loadSpecification(parameterClasses[j]);
                if (paramSpec == null) continue block0;
                actionParams[j] = new JavaNakedObjectActionParamPeer(paramSpec);
            }
            if (this.getFacetProcessor().recognizes(actionMethod)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("  identified action " + actionMethod));
            }
            this.methods[i] = null;
            String fullMethodName = actionMethod.getName();
            Identifier identifier = Identifier.actionIdentifier((String)this.className, (String)fullMethodName, (Class[])parameterTypes);
            JavaNakedObjectActionPeer action = new JavaNakedObjectActionPeer(identifier, actionParams);
            this.getFacetProcessor().process(actionMethod, new JavaIntrospectorMethodRemover(), action, NakedObjectFeatureType.ACTION);
            for (int j = 0; j < actionParams.length; ++j) {
                this.getFacetProcessor().processParams(actionMethod, j, actionParams[j]);
            }
            actionPeers.add(action);
        }
        return this.convertToArray(actionPeers);
    }

    private NakedObjectActionPeer[] convertToArray(List<NakedObjectActionPeer> actions) {
        return actions.toArray(new NakedObjectActionPeer[0]);
    }

    private Method findAndRemoveMethod(MethodScope methodScope, String name, Class<?> returnType, Class<?>[] paramTypes) {
        return MethodFinderUtils.removeMethod(this.methods, methodScope, name, returnType, paramTypes);
    }

    private List<Method> findAndRemovePrefixedNonVoidMethods(MethodScope methodScope, String prefix, Class<?> returnType, int paramCount) {
        return this.findAndRemovePrefixedMethods(methodScope, prefix, returnType, false, paramCount);
    }

    private void findAndRemovePrefixedNonVoidMethods(MethodScope methodScope, String prefix, Class<?> returnType, int paramCount, List<Method> methodListToAppendTo) {
        List<Method> matchingMethods = this.findAndRemovePrefixedMethods(methodScope, prefix, returnType, false, paramCount);
        methodListToAppendTo.addAll(matchingMethods);
    }

    private List<Method> findAndRemovePrefixedMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
        return MethodFinderUtils.removeMethods(this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
    }

    private OrderSet createOrderSet(String order, NakedObjectMemberPeer[] members) {
        if (order != null) {
            SimpleOrderSet set = SimpleOrderSet.createOrderSet(order, members);
            return set;
        }
        DeweyOrderSet set = DeweyOrderSet.createOrderSet(members);
        return set;
    }

    private String invokeSortOrderMethod(String type) {
        Method method = this.findAndRemoveMethod(MethodScope.CLASS, type + "Order", String.class, NO_PARAMETERS_TYPES);
        if (method == null) {
            return null;
        }
        if (!JavaClassUtils.isStatic(method)) {
            LOG.warn((Object)("method " + this.className + "." + type + "Order() must be declared as static"));
            return null;
        }
        String s = (String)this.invokeMethod(method, NO_PARAMETERS);
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    private Object invokeMethod(Method method, Object[] parameters) {
        try {
            return method.invoke(null, parameters);
        }
        catch (IllegalAccessException ignore) {
            LOG.warn((Object)("method " + this.className + "." + method.getName() + "() must be declared as public"));
            return null;
        }
        catch (InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public OrderSet getFields() {
        return this.orderedFields;
    }

    public OrderSet getClassActions() {
        return this.orderedClassActions;
    }

    public OrderSet getObjectActions() {
        return this.orderedObjectActions;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.debug((Object)("finalizing reflector " + this));
    }

    private static NakedObjectAssociationPeer[] orderArray(NakedObjectAssociationPeer[] original, String[] order) {
        NakedObjectAssociationPeer member;
        int i;
        if (order == null) {
            return original;
        }
        for (int i2 = 0; i2 < order.length; ++i2) {
            order[i2] = NameConvertorUtils.simpleName(order[i2]);
        }
        NakedObjectAssociationPeer[] ordered = new NakedObjectAssociationPeer[original.length];
        int orderedIndex = 0;
        block1: for (int orderIndex = 0; orderIndex < order.length; ++orderIndex) {
            for (int memberIndex = 0; memberIndex < original.length; ++memberIndex) {
                NakedObjectAssociationPeer member2 = original[memberIndex];
                if (member2 == null || !member2.getIdentifier().getMemberName().equalsIgnoreCase(order[orderIndex])) continue;
                ordered[orderedIndex++] = original[memberIndex];
                original[memberIndex] = null;
                continue block1;
            }
            if (order[orderIndex].trim().equals("")) continue;
            LOG.warn((Object)("invalid ordering element '" + order[orderIndex]));
        }
        NakedObjectAssociationPeer[] results = new NakedObjectAssociationPeer[original.length];
        int index = 0;
        for (i = 0; i < ordered.length; ++i) {
            member = ordered[i];
            if (member == null) continue;
            results[index++] = member;
        }
        for (i = 0; i < original.length; ++i) {
            member = original[i];
            if (member == null) continue;
            results[index++] = member;
        }
        return results;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.reflector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JavaIntrospectorMethodRemover
    implements MethodRemover {
        private JavaIntrospectorMethodRemover() {
        }

        @Override
        public void removeMethod(MethodScope methodScope, String methodName, Class<?> returnType, Class<?>[] parameterTypes) {
            MethodFinderUtils.removeMethod(JavaIntrospector.this.methods, methodScope, methodName, returnType, parameterTypes);
        }

        @Override
        public List<Method> removeMethods(MethodScope methodScope, String prefix, Class<?> returnType, boolean canBeVoid, int paramCount) {
            return MethodFinderUtils.removeMethods(JavaIntrospector.this.methods, methodScope, prefix, returnType, canBeVoid, paramCount);
        }

        @Override
        public void removeMethod(Method method) {
            for (int i = 0; i < JavaIntrospector.this.methods.length; ++i) {
                if (JavaIntrospector.this.methods[i] == null || !JavaIntrospector.this.methods[i].equals(method)) continue;
                ((JavaIntrospector)JavaIntrospector.this).methods[i] = null;
            }
        }

        @Override
        public void removeMethods(List<Method> methodList) {
            List<Method> methodList2 = methodList;
            block0: for (int i = 0; i < JavaIntrospector.this.methods.length; ++i) {
                if (JavaIntrospector.this.methods[i] == null) continue;
                for (Method method : methodList2) {
                    if (!JavaIntrospector.this.methods[i].equals(method)) continue;
                    ((JavaIntrospector)JavaIntrospector.this).methods[i] = null;
                    continue block0;
                }
            }
        }
    }
}

