package org.nakedobjects.nof.core.adapter;

import java.util.Date;

import org.nakedobjects.noa.adapter.Version;
import org.nakedobjects.noa.util.ByteDecoder;
import org.nakedobjects.noa.util.ByteEncoder;
import org.nakedobjects.noa.util.Encodable;
import org.nakedobjects.nof.core.util.ToString;


public class SerialNumberVersion extends AbstractVersion implements Encodable {
    private final long versionNumber;

    public SerialNumberVersion(final long number, final String user, final Date time) {
        super(user, time);
        versionNumber = number;
    }
    
    public SerialNumberVersion(ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
        versionNumber = decoder.getLong();
    }
    
    public void encode(ByteEncoder encoder) {
        encoder.add(user);
        encoder.add(time.getTime());
        encoder.add(versionNumber);
    }
    
    public boolean different(final Version version) {
        if (version instanceof SerialNumberVersion) {
            SerialNumberVersion other = (SerialNumberVersion) version;
            return versionNumber != other.versionNumber;
        } else {
            return false;
        }
    }

    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof SerialNumberVersion) {
            return !different((SerialNumberVersion) obj);
        } else {
            return false;
        }
    }

    public long getSequence() {
        return versionNumber;
    }

    public int hashCode() {
        return (int) (versionNumber ^ (versionNumber >>> 32));
    }

    protected AbstractVersion next() {
        return new SerialNumberVersion(versionNumber + 1, null, null);
    }
    
    public String sequence() {
        return Long.toString(versionNumber, 16);
    }

    public String toString() {
        return "SerialNumberVersion#" + versionNumber + " " + ToString.timestamp(time);
    }

}
// Copyright (c) Naked Objects Group Ltd.
