package org.nakedobjects.nof.core.adapter.map;

import java.util.Enumeration;
import java.util.Hashtable;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.util.DebugString;


public class IdentityAdapterHashMap implements IdentityAdapterMap {
    private static final Logger LOG = Logger.getLogger(IdentityAdapterHashMap.class);
    private Hashtable adapters;

    public IdentityAdapterHashMap() {
        this(1000);
    }

    public IdentityAdapterHashMap(final int capacity) {
        adapters = new Hashtable(capacity);
    }

    public void add(final Oid oid, final NakedReference adapter) {
        LOG.debug("add " + oid + " as " + adapter);
        adapters.put(oid, adapter);
    }

    public void debugData(final DebugString debug) {
        Enumeration e = oids();
        int count = 0;
        while (e.hasMoreElements()) {
            Oid oid = (Oid) e.nextElement();
            NakedReference object = (NakedReference) getAdapter(oid);
            debug.append(count++, 5);
            debug.append(" '");
            debug.append(oid.toString(), 25);
            debug.append("'    ");
            debug.appendln(object.toString());
        }
    }

    public NakedObject getAdapter(final Oid oid) {
        return (NakedObject) adapters.get(oid);
    }

    public String debugTitle() {
        return "Identity adapter map";
    }

    public boolean isIdentityKnown(final Oid oid) {
        return adapters.containsKey(oid);
    }

    public Enumeration oids() {
        return adapters.keys();
    }

    public void remove(final Oid oid) {
        LOG.debug("remove " + oid);
        adapters.remove(oid);
    }

    public void reset() {
        LOG.debug("reset");
        adapters.clear();
    }

    public void shutdown() {
        LOG.debug("shutdown");
        adapters.clear();
    }
}
// Copyright (c) Naked Objects Group Ltd.
