package org.nakedobjects.nof.core.adapter.map;

import java.util.Enumeration;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.Oid;
import org.nakedobjects.nof.core.util.DebugInfo;


/**
 * A map of the objects' identities and the adapters' of the objects.
 */
public interface IdentityAdapterMap extends DebugInfo {

    /**
     * Add an adapter for a given oid
     */
    public void add(final Oid oid, final NakedReference adapter);

    /**
     * Get the adapter identified by the specified OID.
     */
    public NakedObject getAdapter(final Oid oid);

    /**
     * Determine if an adapter exists for the the specified OID.
     */
    public boolean isIdentityKnown(final Oid oid);

    /**
     * Return an enumeration of all the knows oids.
     */
    public Enumeration oids();

    /**
     * Remove the adapter for the given oid
     */
    public void remove(final Oid oid);

    /**
     * Clear out all mappings.
     */
    public void reset();

    public void shutdown();
}
// Copyright (c) Naked Objects Group Ltd.
