package org.nakedobjects.nof.core.adapter.map;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.NameConvertor;


/**
 * Provides a simple key for reliably getting hold of the adapter for an 'internal' collection used by a
 * domain object. Combines the parent object (the domain object) and the collection field to create an
 * unchanging key.
 */
public class InternalCollectionKey {
    private final NakedObject parent;
    private final String fieldName;

    // DKH 20060404: automatic intern'ing.
    /*
     * rcm - this helps in the current situation where we repeatedly create a key, on the fly, to identify a
     * collection. In future we should assign an OID to the collection in the same way we do with any other
     * obect. TODO create OID for collection when collection created; then remove this class.
     */
    public static void reset() {
        threadLocalKeyByFieldNameByNakedObject().clear();
    }

    private static java.util.Hashtable keyByFieldNameByNakedObjectByThread = new java.util.Hashtable();

    protected static java.util.Hashtable threadLocalKeyByFieldNameByNakedObject() {
        Thread thread = Thread.currentThread();
        java.util.Hashtable keyByFieldNameByNakedObject = (java.util.Hashtable) keyByFieldNameByNakedObjectByThread.get(thread);
        if (keyByFieldNameByNakedObject == null) {
            keyByFieldNameByNakedObject = new java.util.Hashtable();
            keyByFieldNameByNakedObjectByThread.put(thread, keyByFieldNameByNakedObject);
        }
        return keyByFieldNameByNakedObject;
    }

    public static InternalCollectionKey createKey(final NakedObject parent, final String fieldName) {
        java.util.Hashtable keyByFieldNameByNakedObject = threadLocalKeyByFieldNameByNakedObject();
        java.util.Hashtable keyByFieldName = (java.util.Hashtable) keyByFieldNameByNakedObject.get(parent);
        if (keyByFieldName == null) {
            keyByFieldName = new java.util.Hashtable();
            keyByFieldNameByNakedObject.put(parent, keyByFieldName);
        }
        InternalCollectionKey key = (InternalCollectionKey) keyByFieldName.get(fieldName);
        if (key == null) {
            key = new InternalCollectionKey(parent, fieldName);
            keyByFieldName.put(fieldName, key);
        }
        return key;
    }

    private InternalCollectionKey(final NakedObject parent, final String fieldName) {
        Assert.assertNotNull("parent", parent);
        Assert.assertNotNull("fieldName", fieldName);

        this.parent = parent;
        this.fieldName = NameConvertor.simpleName(fieldName);
    }

    public int hashCode() {
        return parent.hashCode() + fieldName.hashCode();
    }

    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof InternalCollectionKey) {
            InternalCollectionKey other = (InternalCollectionKey) obj;
            return other.parent.equals(parent) && other.fieldName.equals(fieldName);
        } else {
            return false;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
