package org.nakedobjects.nof.core.adapter.value;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.nof.core.util.UnexpectedCallException;


public abstract class AbstractImageAdapter extends AbstractValueAdapter implements ImageValue {
    private static final char[] BASE_64_CHARS = { 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
            'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
            'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
            '+', '/', };

    protected static final byte[] REVERSE_BASE_64_CHARS = new byte[0x100];
    private static final Logger LOG = Logger.getLogger(AbstractImageAdapter.class);

    static {
        for (int i = 0; i < REVERSE_BASE_64_CHARS.length; i++) {
            REVERSE_BASE_64_CHARS[i] = -1;
        }
        for (byte i = 0; i < BASE_64_CHARS.length; i++) {
            REVERSE_BASE_64_CHARS[BASE_64_CHARS[i]] = i;
        }
    }

    public byte[] getAsByteArray() {
        final int[] flatIntArray = flatten();
        final byte[] byteArray = new byte[flatIntArray.length * 4];
        for (int i = 0; i < flatIntArray.length; i++) {
            final int value = flatIntArray[i];
            byteArray[i * 4] = (byte) ((value >> 24) & 0xff);
            byteArray[i * 4 + 1] = (byte) ((value >> 16) & 0xff);
            byteArray[i * 4 + 2] = (byte) ((value >> 8) & 0xff);
            byteArray[i * 4 + 3] = (byte) (value & 0xff);
        }
        return byteArray;
    }

    private static int byteArrayToInt(final byte[] byteArray, final int offset) {
        int value = 0;
        for (int i = 0; i < 4; i++) {
            final int shift = (4 - 1 - i) * 8;
            value += (byteArray[i + offset] & 0x000000FF) << shift;
        }
        return value;
    }

    public void restoreFromByteArray(final byte[] byteArray) {
        final int[] flatIntArray = new int[byteArray.length / 4];
        for (int i = 0; i < flatIntArray.length; i++) {
            flatIntArray[i] = byteArrayToInt(byteArray, i * 4);
        }
        setPixels(inflate(flatIntArray));
    }

    private int[] flatten() {
        final int[][] image = getPixels();
        final int[] flatArray = new int[(getHeight() * getWidth()) + 2];
        int flatIndex = 0;
        flatArray[flatIndex++] = getHeight();
        flatArray[flatIndex++] = getWidth();
        for (int i = 0; i < getHeight(); i++) {
            for (int j = 0; j < getWidth(); j++) {
                flatArray[flatIndex++] = image[i][j];
            }
        }
        return flatArray;
    }

    private static int[][] inflate(final int[] flatIntArray) {
        int flatIndex = 0;
        final int height = flatIntArray[flatIndex++];
        final int width = flatIntArray[flatIndex++];

        final int[][] newImage = new int[height][width];

        for (int i = 0; i < height; i++) {
            for (int j = 0; j < width; j++) {
                newImage[i][j] = flatIntArray[flatIndex++];
            }
        }
        return newImage;
    }

    protected String doEncode() {
        int[][] image = getPixels();
        int lines = image.length;
        int width = image[0].length;
        StringBuffer encodeData = new StringBuffer(lines * width * 4);
        encodePixel(lines, encodeData);
        encodePixel(width, encodeData);
        for (int line = 0; line < lines; line++) {
            for (int pixel = 0; pixel < width; pixel++) {
                encodePixel(image[line][pixel], encodeData);
            }
        }
        return encodeData.toString();
    }

    protected Image createImage(final int[][] pixels) {
        int lines = pixels.length;
        int width = pixels[0].length;
        int[] pix = new int[lines * width];
        int offset = 0;
        for (int line = 0; line < lines; line++) {
            System.arraycopy(pixels[line], 0, pix, offset, width);
            offset += width;
        }
        MemoryImageSource source = new MemoryImageSource(width, lines, pix, 0, width);
        return java.awt.Toolkit.getDefaultToolkit().createImage(source);
    }

    private int decodePixel(final String data, final int item) {
        int offset = item * 4;
        int pixel = 0;
        for (int i = 0; i < 4; i++) {
            char c = data.charAt(offset + i);
            byte b = REVERSE_BASE_64_CHARS[c];
            pixel = (pixel << 6) + b;
        }
        return pixel;
    }

    private void encodePixel(final int pixel, final StringBuffer encodeData) {
        // TODO the encoding is poor as the negative numbers are not dealt with properly because the 6 MSBs
        // are not included.
        for (int i = 3; i >= 0; i--) {
            int bitsToShift = i * 6;
            int c = pixel >> bitsToShift;
            char cc = BASE_64_CHARS[c & 0x3F];
            encodeData.append(cc);
        }
    }

    public String getIconName() {
        return null;
    }

    protected abstract int[][] getPixels();

    protected int[][] grabPixels(final Image image) {
        int width = image.getWidth(null);
        int lines = image.getHeight(null);
        int pixels[] = new int[width * lines];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, width, lines, pixels, 0, width);
        grabber.setColorModel(ColorModel.getRGBdefault());
        try {
            if (grabber.grabPixels() && (grabber.status() & ImageObserver.ALLBITS) != 0) {
                int[][] array = new int[lines][width];
                int srcPos = 0;
                for (int line = 0; line < lines; line++) {
                    array[line] = new int[width];
                    System.arraycopy(pixels, srcPos, array[line], 0, width);
                    srcPos += width;
                }
                return array;
            }
            // TODO what happens if the grab fails?
            return new int[lines][width];
        } catch (InterruptedException e) {
            throw new NakedObjectRuntimeException(e);
        }
    }

    public void parseTextEntry(final String text) {
        throw new UnexpectedCallException();
    }
    
    protected void doParse(String entry) {}

    protected void doRestore(String data) {
        int lines = decodePixel(data, 0);
        int width = decodePixel(data, 1);
        int[][] image = new int[lines][width];
        int offset = 2;
        for (int line = 0; line < lines; line++) {
            for (int pixel = 0; pixel < width; pixel++) {
                image[line][pixel] = decodePixel(data, offset++);
            }
        }
        setPixels(image);
    }

    protected abstract void setPixels(int[][] pixels);

    public void setMask(String mask) {}

    public String titleString() {
        return "image";
    }
}
// Copyright (c) Naked Objects Group Ltd.
