package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.BooleanValue;
import org.nakedobjects.noa.persist.ObjectPersistenceException;


public class BooleanAdapter extends AbstractValueAdapter implements BooleanValue {
    private Boolean value;

    public BooleanAdapter() {
        value = Boolean.FALSE;
    }

    public BooleanAdapter(final Boolean value) {
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String titleString() {
        return isEmpty() ? "" : isSet() ? "True" : "False";
    }

    public String getIconName() {
        return "boolean";
    }

    public Class getValueClass() {
        return boolean.class;
    }

    // ///// Accessor ///////

    /**
     * @deprecated use {@link #booleanValue}
     */
    public Boolean boolValue() {
        return value;
    }
    
    public Boolean booleanValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    public boolean isSet() {
        return isEmpty() ? false : value.booleanValue();
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void reset() {
        value = Boolean.FALSE;
    }

    public void set() {
        value = Boolean.TRUE;
    }

    public void toggle() {
        value = isEmpty() ? Boolean.TRUE : new Boolean(!value.booleanValue());
    }

    protected void doParse(String entry) {
        if ("true".startsWith(entry.toLowerCase())) {
            set();
        } else if ("false".startsWith(entry.toLowerCase())) {
            reset();
        } else {
            throw new TextEntryParseException("Not a logical value " + entry);
        }
    }

    // ///// Encode, Decode ///////

    protected String doEncode() {
        return isSet() ? "T" : "F";
    }

    protected void doRestore(String data) {
        if (data.length() != 1) {
            throw new ObjectPersistenceException("Invalid data for logical, expected 1 byte, got " + data.length());
        }
        switch (data.charAt(0)) {
        case 'T':
            set();
            break;
        case 'F':
            reset();
            break;
        default:
            throw new ObjectPersistenceException("Invalid data for logical, expected 'T', 'F' or 'N, but got " + data.charAt(0));
        }
    }

    // ///// Semantics ///////

    public void setMask(String mask) {}

    public int defaultTypicalLength() {
        return 5;
    }

    public String toString() {
        return "BooleanAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
