package org.nakedobjects.nof.core.adapter.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;

import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.adapter.value.ByteValue;
import org.nakedobjects.nof.core.conf.Configuration;
import org.nakedobjects.nof.core.context.NakedObjectsContext;


public class ByteAdapter extends AbstractValueAdapter implements ByteValue {
    private static final NumberFormat DEFAULT_FORMAT = NumberFormat.getNumberInstance();
    private NumberFormat format = DEFAULT_FORMAT;
    private Byte value;

    public ByteAdapter() {
        String formatRequired = NakedObjectsContext.getConfiguration().getString(Configuration.ROOT + "value.format.byte");
        if (formatRequired == null) {
            format = DEFAULT_FORMAT;
        } else {
            setMask(formatRequired);
        }
    }

    public ByteAdapter(final Byte value) {
        this();
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String titleString() {
        return value == null ? "" : format.format(value);
    }

    public String getIconName() {
        return "byte";
    }

    public Class getValueClass() {
        return Byte.class;
    }

    // ///// Accessor ///////

    public Byte byteValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void setValue(final Byte value) {
        this.value = value;
    }

    protected void doParse(String entry) {
            try {
                value = new Byte(format.parse(entry).byteValue());
            } catch (ParseException e) {
                throw new TextEntryParseException("Not a number " + entry, e);
            }
    }

    // ///// Encode, Decode ///////

    public String doEncode() {
        return value.toString();
    }

    protected void doRestore(String data) {
        value = new Byte(data);
    }

    // ///// Semantics ///////

    public void setMask(String mask) {
        format = new DecimalFormat(mask);
    }

    public int defaultTypicalLength() {
        return 4;
    }

    // ///// toString ///////

    public String toString() {
        return "ByteAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
