package org.nakedobjects.nof.core.adapter.value;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.value.CharValue;


public class CharAdapter extends AbstractValueAdapter implements CharValue {
    private Character value;

    public CharAdapter() {}

    public CharAdapter(final char value) {
        this.value = new Character(value);
    }

    public CharAdapter(final Character value) {
        this.value = value;
    }

    // ///// titleString, icon, valueClass ///////

    public String getIconName() {
        return "char";
    }

    public Class getValueClass() {
        return Character.class;
    }

    // ///// Accessor ///////

    public Character charValue() {
        return value;
    }

    public Object getObject() {
        return value;
    }

    // ///// Null Handling ///////

    public boolean canClear() {
        return true;
    }

    public void clear() {
        value = null;
    }

    public boolean isEmpty() {
        return value == null;
    }

    // ///// Mutator ///////

    public void setValue(final Character value) {
        this.value = value;
    }

    public void doParse(final String entry) {
        if (entry.length() > 1) {
            throw new InvalidEntryException("Only a single character is required");
        } else {
            value = new Character(entry.charAt(0));
        }
    }

    // ///// Encode, Decode ///////

    protected String doEncode() {
        return value.toString();
    }

    protected void doRestore(String data) {
        value = new Character(data.charAt(0));
    }

    // ///// Semantics ///////

    public void setMask(String mask) {}

    public int defaultTypicalLength() {
        return 1;
    }

    public String titleString() {
        return value == null ? "" : value.toString();
    }

    public String toString() {
        return "CharAdapter: " + value;
    }

}
// Copyright (c) Naked Objects Group Ltd.
